<?php
/**
 * Style Options.
 *
 * @package ConvertPro
 */

if ( ! defined( 'ABSPATH' ) ) {
	die();
}

$user_inactivity = esc_attr( get_option( 'cp_user_inactivity' ) );
if ( ! $user_inactivity ) {
	$user_inactivity = '60';
}

if ( isset( $_REQUEST['cpro_admin_page_menu_nonce'] ) && ! wp_verify_nonce( $_REQUEST['cpro_admin_page_menu_nonce'], 'cpro_admin_page_menu' ) ) {
	die( 'No direct script access allowed!' );
}

$style   = isset( $_GET['post'] ) ? sanitize_text_field( $_GET['post'] ) : '';
$step_id = '1';

$shortcode = '[cp_popup display="inline" style_id="' . $style . '" step_id = "' . $step_id . '"][/cp_popup]';

/*** Array contains optin form options */
$optin_form = array();



$form_validation_link = 'You can refer to the article <a rel="noopener" target="_blank" href="' . esc_url_raw( 'https://www.convertpro.net/docs/how-to-enable-form-field-validation/' ) . '">here.</a>';

$recaptcha_setting_link = 'You can set reCaptcha Site Key and Secret Key <a rel="noopener" target="_blank" href="' . CP_V2_Tab_Menu::get_page_url( 'general-settings' ) . '#recaptcha">here.</a>';
/*** Array contains Configure options */
$configure = array(
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'autoload_on_duration',
		'opts'         => array(
			'title'       => '',
			'value'       => true,
			'on'          => __( 'ON', 'convertpro' ),
			'off'         => __( 'OFF', 'convertpro' ),
			'description' => '',
			'tags'        => 'autoload,seconds,after,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Few Seconds on Page',
	),
	array(
		'type'         => 'number',
		'class'        => '',
		'name'         => 'load_on_duration',
		'opts'         => array(
			'title'  => __( 'Display when a user is on the page for at least:', 'convertpro' ),
			'link'   => __( 'By default, this modal will be effective for all. However using controls above, you can hide it for certain visitors.', 'convertpro' ),
			'value'  => 1,
			'min'    => 1,
			'max'    => 100,
			'step'   => 1,
			'suffix' => 'Seconds',
			'tags'   => 'load,seconds,after,duration,launch,smart',
		),
		'panel'        => 'Launch',
		'dependency'   => array(
			'name'     => 'autoload_on_duration',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Few Seconds on Page',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'autoload_on_no_page_visit',
		'opts'         => array(
			'title'       => '',
			'value'       => false,
			'on'          => __( 'ON', 'convertpro' ),
			'off'         => __( 'OFF', 'convertpro' ),
			'description' => '',
			'tags'        => 'autoload,seconds,after,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Number of Page Visits',
	),
	array(
		'type'         => 'number',
		'class'        => '',
		'name'         => 'load_on_no_page_visit',
		'opts'         => array(
			'title'  => __( 'Display when a user viewed number of pages count:', 'convertpro' ),
			'value'  => 1,
			'min'    => 1,
			'max'    => 100,
			'step'   => 1,
			'suffix' => '',
			'tags'   => 'load,seconds,after,duration,launch,smart',
		),
		'panel'        => 'Launch',
		'dependency'   => array(
			'name'     => 'autoload_on_no_page_visit',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Number of Page Visits',
	),
	array(
		'type'         => 'dropdown',
		'name'         => 'load_on_page_visit_type',
		'opts'         => array(
			'options' => array(
				'is-more-than' => __( 'Is more than', 'convertpro' ),
				'is-less-than' => __( 'Is less than', 'convertpro' ),
			),
			'value'   => 'is-more-than',
			'tags'    => 'load,seconds,after,duration,launch,smart',
		),
		'panel'        => 'Launch',
		'dependency'   => array(
			'name'     => 'autoload_on_no_page_visit',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Number of Page Visits',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'cp_show_note_page_view',
		'opts'         => array(
			'link'  => __(
				'<strong>Note: </strong>If Cookie is enabled and user performs the Close/Submit action, then on next visit of the site, this popup will not be triggered as the cookie will be set for it.
<br><br><strong>For more information you can refer to the article <a rel="noopener" target="_blank" href="https://www.convertpro.net/docs/trigger-popup-based-on-page-visits/">here.</a></strong>',
				'convertpro'
			),
			'value' => '',
			'title' => '',
			'class' => 'cp-show-note-page-view',
		),
		'panel'        => 'Launch',
		'dependency'   => array(
			'name'     => 'autoload_on_no_page_visit',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Number of Page Visits',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'modal_exit_intent',
		'opts'         => array(
			'title' => __( 'Display when a user is about to leave the site', 'convertpro' ),
			'value' => false,
			'on'    => __( 'ON', 'convertpro' ),
			'off'   => __( 'OFF', 'convertpro' ),
			'tags'  => 'exit,intent,leaves,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'Exit Intent',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'autoload_on_scroll',
		'opts'         => array(
			'title'       => '',
			'value'       => false,
			'on'          => __( 'ON', 'convertpro' ),
			'off'         => __( 'OFF', 'convertpro' ),
			'description' => '',
			'tags'        => 'autoload,scroll,visitor,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Scroll / Display Within Range',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'show_after_within_scroll_info',
		'opts'         => array(
			'link'  => __(
				'<strong>After Scroll Trigger - </strong>Please keep the first slider value higher than the second. <a rel="noopener" target="_blank" href="https://www.convertpro.net/docs/after-scroll-trigger-for-slide-in-and-infobar/">Know more.</a><br><br>
				<strong>Display Within Range - </strong>Please keep the second slider value higher than the first. <a rel="noopener" target="_blank" href="https://www.convertpro.net/docs/display-within-range-call-to-action-in-convert-pro/">Know more.</a>',
				'convertpro'
			),
			'value' => '',
			'title' => '',
			'class' => 'cp_show_after_within_scroll_info',
		),
		'panel'        => 'Launch',
		'dependency'   => array(
			'name'     => 'autoload_on_scroll',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Scroll / Display Within Range',
	),
	array(
		'type'         => 'slider',
		'class'        => '',
		'name'         => 'load_after_scroll',
		'opts'         => array(
			'title'       => __( 'Display at - Display when a user scrolls the page:', 'convertpro' ),
			'value'       => 75,
			'min'         => 1,
			'max'         => 100,
			'step'        => 1,
			'suffix'      => '%',
			'description' => '',
			'tags'        => 'load,scroll,launch,smart',
		),
		'panel'        => 'Launch',
		'dependency'   => array(
			'name'     => 'autoload_on_scroll',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Scroll / Display Within Range',
	),
	array(
		'type'         => 'slider',
		'class'        => '',
		'name'         => 'close_after_scroll',
		'opts'         => array(
			'title'       => __( 'Hide at - Close when a user scrolls the page:', 'convertpro' ),
			'value'       => 0,
			'min'         => 0,
			'max'         => 100,
			'step'        => 1,
			'suffix'      => '%',
			'description' => '',
			'tags'        => 'load,scroll,launch,smart',
		),
		'panel'        => 'Launch',
		'dependency'   => array(
			'name'     => 'autoload_on_scroll',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Scroll / Display Within Range',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'inactivity',
		'opts'         => array(
			/* translators: %s percentage */
			'title'       => sprintf( __( 'Display when a user is inactive for %s seconds', 'convertpro' ), $user_inactivity ),
			'value'       => false,
			'on'          => __( 'ON', 'convertpro' ),
			'off'         => __( 'OFF', 'convertpro' ),
			'description' => '',
			'tags'        => 'inactivity,activity,user,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'User Inactivity',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'inactivity_link',
		'opts'         => array(
			/* translators: %s percentage */
			'link'  => sprintf( __( "You can change inactivity time <a rel='noopener' target='_blank' href='%s'>here.</a>", 'convertpro' ), CP_V2_Tab_Menu::get_page_url( 'general-settings' ) ),
			'value' => '',
			'title' => '',
			'tags'  => 'inactivity,link,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'inactivity',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'User Inactivity',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_after_post',
		'opts'         => array(
			'title' => __( 'Display when a user finishes reading the full blog post', 'convertpro' ),
			'value' => false,
			'on'    => __( 'ON', 'convertpro' ),
			'off'   => __( 'OFF', 'convertpro' ),
			'tags'  => 'after,post,content,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Blog Post',
	),

	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_display_inline',
		'opts'         => array(
			'title'       => __( 'Display Inline', 'convertpro' ),
			'value'       => true,
			'on'          => __( 'YES', 'convertpro' ),
			'off'         => __( 'NO', 'convertpro' ),
			'description' => __( 'If enabled, module will display inline as a part of page / post content.', 'convertpro' ),
			'tags'        => 'inline,display,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
	),
	array(
		'type'         => 'dropdown',
		'class'        => '',
		'name'         => 'inline_position',
		'opts'         => array(
			'title'       => __( 'Display Inline Position', 'convertpro' ),
			'value'       => 'both',
			'description' => __( 'Select the position, where you want to display module inline.', 'convertpro' ),
			'options'     => array(
				'before_post'     => __( 'Before Post', 'convertpro' ),
				'after_post'      => __( 'After Post', 'convertpro' ),
				'both'            => __( 'Both', 'convertpro' ),
				'between_content' => __( 'Inside Post/Page Content', 'convertpro' ),
			),
			'tags'        => 'inline,position,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'enable_display_inline',
			'operator' => '==',
			'value'    => 'true',
		),
	),
	array(
		'type'         => 'dropdown',
		'class'        => '',
		'name'         => 'select_inline_location',
		'opts'         => array(
			'title'       => __( 'Location on post/page', 'convertpro' ),
			'value'       => 'after_blocks',
			'description' => __( 'Popup will be displayed at a selected location on post/page block editor only.', 'convertpro' ),
			'options'     => array(
				'after_blocks'    => __( 'After certain number of blocks', 'convertpro' ),
				'before_headings' => __( 'Before certain number of Heading blocks', 'convertpro' ),
			),
			'tags'        => 'inline,position,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'inline_position',
			'operator' => '==',
			'value'    => 'between_content',
		),
	),
	array(
		'type'         => 'number',
		'class'        => '',
		'name'         => 'number_of_layout',
		'opts'         => array(
			'title'  => __( 'Layout will be inserted after selected number of blocks:', 'convertpro' ),
			'value'  => 1,
			'min'    => 1,
			'max'    => 100,
			'step'   => 1,
			'suffix' => 'Blocks',
			'tags'   => 'load,seconds,after,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   =>
			array(
				'name'     => 'select_inline_location',
				'operator' => '==',
				'value'    => 'after_blocks',
			),
	),
	array(
		'type'         => 'number',
		'class'        => '',
		'name'         => 'number_of_layout_heading',
		'opts'         => array(
			'title'  => __( 'Layout will be inserted before the selected number of Heading blocks.', 'convertpro' ),
			'value'  => 1,
			'min'    => 1,
			'max'    => 100,
			'step'   => 1,
			'suffix' => 'Blocks',
			'tags'   => 'load,seconds,after,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   =>
			array(
				'name'     => 'select_inline_location',
				'operator' => '==',
				'value'    => 'before_headings',
			),
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_custom_scroll',
		'opts'         => array(
			'title'       => '',
			'value'       => false,
			'on'          => __( 'YES', 'convertpro' ),
			'off'         => __( 'NO', 'convertpro' ),
			'description' => '',
			'tags'        => 'custom,enable,scroll,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'After Certain CSS Element',
	),
	array(
		'type'         => 'textfield',
		'class'        => '',
		'name'         => 'enable_scroll_class',
		'opts'         => array(
			'title'       => __( 'Display when following CSS Class / ID is visible:', 'convertpro' ),
			'value'       => '',
			'description' => '',
			'tags'        => 'scroll,enable,class,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'enable_custom_scroll',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'After Certain CSS Element',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'on_scroll_txt',
		'opts'         => array(
			'link'  => __( 'You can add multiple classes or IDs seprated by comma. Example - #button, .widget-title, .site-description', 'convertpro' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'dependency'   => array(
			'name'     => 'enable_custom_scroll',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'After Certain CSS Element',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'show_cta_info',
		'opts'         => array(
			/* translators: %s percentage */
			'link'  => sprintf( __( '%s.', 'convertpro' ), '<strong>Enable this if you want to show this call-to-action when a particular cookie is set</strong>' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Cookie Based Trigger',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_custom_cookies',
		'opts'         => array(
			'title' => '',
			'value' => false,
			'on'    => __( 'YES', 'convertpro' ),
			'off'   => __( 'NO', 'convertpro' ),
			'tags'  => 'custom,enable,cookies,repeat,control,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'Cookie Based Trigger',
	),
	array(
		'type'         => 'textfield',
		'class'        => '',
		'name'         => 'enable_cookies_class',
		'opts'         => array(
			'title'       => __( 'Enter cookie name / names that will trigger the CTA', 'convertpro' ),
			'value'       => '',
			'description' => __( 'Enter the cookie name or names which when set, you wish to trigger this call-to-action.', 'convertpro' ),
			'tags'        => 'enable,cookies,repeat,control,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'enable_custom_cookies',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Cookie Based Trigger',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'on_cookie_txt',
		'opts'         => array(
			'link'  => __( 'You can add multiple Cookie names separated by a comma. Ex - firstcookie_name,secondcookie_name,thirdcookie_name', 'convertpro' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'dependency'   => array(
			'name'     => 'enable_custom_cookies',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Cookie Based Trigger',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'hide_cta_link',
		'opts'         => array(
			'link'  => __( "Do you want to hide this CTA when a particular cookie is set? You can do that <a class='hide-cta-class'>here</a>", 'convertpro' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'dependency'   => array(
			'name'     => 'enable_custom_cookies',
			'operator' => '==',
			'value'    => '1',
		),
		'category'     => 'Cookie Based Trigger',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_adblock_detection',
		'opts'         => array(
			'title'       => '',
			'value'       => false,
			'on'          => __( 'YES', 'convertpro' ),
			'off'         => __( 'NO', 'convertpro' ),
			'description' => '',
			'tags'        => 'launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'Ad Block detection',
	),

	/* Visitors Field */
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'all_visitor_info',
		'opts'         => array(
			/* translators: %s percentage */
			'link'  => sprintf( __( '%s.', 'convertpro' ), '<strong>By default it will be shown to all visitors</strong>' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Visitors',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_visitors',
		'opts'         => array(
			'title'       => '',
			'value'       => '',
			'on'          => __( 'ON', 'convertpro' ),
			'off'         => __( 'OFF', 'convertpro' ),
			'description' => __( 'Do you wish to display this to visitors who are First Time or Returning?', 'convertpro' ),
			'tags'        => 'first,load,time,visitors,target,visitors',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Visitors',
	),
	array(
		'type'         => 'dropdown',
		'name'         => 'visitor_type',
		'opts'         => array(
			'title'       => __( 'Visitor Type', 'convertpro' ),
			'options'     => array(
				'first-time' => __( 'First Time Visitors Only', 'convertpro' ),
				'returning'  => __( 'Returning Visitors Only', 'convertpro' ),
			),
			'value'       => 'first-time',
			'description' => __( 'Do you wish to display this to visitors who are First Time or Returning?', 'convertpro' ),
			'tags'        => 'first,load,time,visitors,target,visitors',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Visitors',
		'dependency'   => array(
			'name'     => 'enable_visitors',
			'operator' => '==',
			'value'    => 'true',
		),
	),
	/* Referrer Field */
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_referrer',
		'opts'         => array(
			'title'       => '',
			'value'       => '',
			'on'          => __( 'ON', 'convertpro' ),
			'off'         => __( 'OFF', 'convertpro' ),
			'description' => __( 'Track the source your visitors come from', 'convertpro' ),
			'tags'        => 'referrer,detection,visitors',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Referrer',
	),
	array(
		'type'         => 'dropdown',
		'name'         => 'referrer_type',
		'opts'         => array(
			'title'       => __( 'Display Type', 'convertpro' ),
			'options'     => array(
				'hide-from'  => __( 'Hide From', 'convertpro' ),
				'display-to' => __( 'Display To', 'convertpro' ),
			),
			'value'       => 'hide-from',
			'description' => __( 'Track the source your visitors come from', 'convertpro' ),
			'tags'        => 'referrer,detection,visitors',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Referrer',
		'dependency'   => array(
			'name'     => 'enable_referrer',
			'operator' => '==',
			'value'    => 'true',
		),
	),
	array(
		'type'         => 'tags',
		'class'        => '',
		'name'         => 'display_to',
		'opts'         => array(
			'title'       => __( 'Visitors coming from -', 'convertpro' ),
			'value'       => '',
			'tags'        => 'display,visitors',
			'description' => __( 'Display it to visitors who come from a particular domain / domains. Mention the domain name or list of domain names separated by a comma. Eg: google.com, facebook.com', 'convertpro' ),
		),
		'dependency'   => array(
			'name'     => 'referrer_type',
			'operator' => '==',
			'value'    => 'display-to',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'Referrer',
	),
	array(
		'type'         => 'tags',
		'class'        => '',
		'name'         => 'hide_from',
		'opts'         => array(
			'title'       => __( 'Visitors who come from -', 'convertpro' ),
			'value'       => '',
			'tags'        => 'hide,visitors',
			'description' => __( 'Hide it from visitors who come from a particular domain / domains. Mention the domain name or list of domain names separated by a comma. Eg: google.com, facebook.com', 'convertpro' ),
		),
		'dependency'   => array(
			'name'     => 'referrer_type',
			'operator' => '==',
			'value'    => 'hide-from',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Referrer',
	),
	/* Scheduler */
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_scheduler',
		'opts'         => array(
			'title' => __( 'Do you wish to schedule this design to display later?', 'convertpro' ),
			'value' => false,
			'on'    => __( 'YES', 'convertpro' ),
			'off'   => __( 'NO', 'convertpro' ),
			'tags'  => 'custom,enable,launch',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'dashicons dashicons-clock',
		'category'     => 'Schedule',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'enable_scheduler_txt',
		'opts'         => array(
			'link'  => __( 'Select the time period between which you wish to display this design.', 'convertpro' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'dependency'   => array(
			'name'     => 'enable_scheduler',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Schedule',
	),
	array(
		'type'         => 'datetimepicker',
		'class'        => '',
		'name'         => 'start_date',
		'opts'         => array(
			'title'       => __( 'Start Time', 'convertpro' ),
			'value'       => '',
			'description' => __( 'Select the particular date and time you wish to start displaying this.', 'convertpro' ),
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'dashicons dashicons-clock',
		'dependency'   => array(
			'name'     => 'enable_scheduler',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Schedule',
	),
	array(
		'type'         => 'datetimepicker',
		'class'        => '',
		'name'         => 'end_date',
		'opts'         => array(
			'title'       => __( 'End Time', 'convertpro' ),
			'value'       => '',
			'description' => 'Select the particular date and time you wish to stop displaying this.',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'dashicons dashicons-clock',
		'dependency'   => array(
			'name'     => 'enable_scheduler',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Schedule',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'custom_cls_text_head',
		'opts'         => array(
			'link'  => __( 'Display when the user clicks a link, button or any element', 'convertpro' ),
			'class' => 'cp-custom-class',
			'value' => '',
			'title' => '',
			'tags'  => 'custom,shortcode,manual,display',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'category'     => 'On Click',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_custom_class',
		'opts'         => array(
			'title'       => '',
			'value'       => false,
			'on'          => __( 'YES', 'convertpro' ),
			'off'         => __( 'NO', 'convertpro' ),
			'description' => '',
			'tags'        => 'custom,enable,class,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'category'     => 'On Click',
	),
	array(
		'type'         => 'button',
		'class'        => '',
		'name'         => 'copy_link_code_button',
		'opts'         => array(
			'title'       => __( 'Copy link code', 'convertpro' ),
			'value'       => __( 'Copy Link Code', 'convertpro' ),
			'description' => '',
			'tags'        => 'copy-link,css,class,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'dependency'   => array(
			'name'     => 'enable_custom_class',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'On Click',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'copy_link_cls_code_button',
		'opts'         => array(
			'link'  => __( 'Paste this copied code in your page. Call-to-action will appear when a user clicks on it.', 'convertpro' ),
			'class' => 'cp-custom-class',
			'value' => '',
			'title' => '',
			'tags'  => 'custom,shortcode,manual,display',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'dependency'   => array(
			'name'     => 'enable_custom_class',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'On Click',
	),
	array(
		'type'         => 'textfield',
		'class'        => '',
		'name'         => 'custom_class',
		'opts'         => array(
			'title'       => __( 'Enter your CSS Class or ID', 'convertpro' ),
			'value'       => '',
			'description' => '',
			'tags'        => 'custom,enable,css,class,launch,smart',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'dependency'   => array(
			'name'     => 'enable_custom_class',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'On Click',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'custom_cls_text',
		'opts'         => array(
			'link'  => __( 'Enter unique CSS Class / ID name of the element. Call-to-action will appear when a user clicks on it. You can add multiple classes or IDs separated by comma. <br><br>Example - #button, .widget-title, .site-description', 'convertpro' ),
			'class' => 'cp-custom-class',
			'value' => '',
			'title' => '',
			'tags'  => 'custom,shortcode,manual,display',
		),
		'panel'        => 'Launch',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'dependency'   => array(
			'name'     => 'enable_custom_class',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'On Click',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'inline_shortcode',
		'opts'         => array(
			'link'        => '<input type="text" id="cpro-shortcode" onfocus="this.select();" readonly="readonly" class="large-text code" value="' . htmlspecialchars( $shortcode, ENT_COMPAT, 'UTF-8' ) . '">',
			'class'       => 'cp-shortcode',
			'value'       => '',
			'title'       => __( 'Display Inline', 'convertpro' ),
			'description' => __( 'Use this shortcode to display this call-to-action inline as a part of the page content / Widget area.', 'convertpro' ),
			'tags'        => 'inline,shortcode,manual,display',
		),
		'panel'        => 'Embed',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
	),

	array(
		'type'         => 'target_rule',
		'class'        => '',
		'name'         => 'target_rule_display',
		'opts'         => array(
			'title'          => __( 'Display Rules', 'convertpro' ),
			'value'          => '[{"type":"basic-global","specific":null}]',
			'tags'           => 'site,enable,target,pages',
			'rule_type'      => 'display',
			'add_rule_label' => __( 'Add Display Rule', 'convertpro' ),
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'category'     => 'Pages',
	),
	array(
		'type'         => 'target_rule',
		'class'        => '',
		'name'         => 'target_rule_exclude',
		'opts'         => array(
			'title'          => __( 'Exclusion Rules', 'convertpro' ),
			'value'          => '[]',
			'tags'           => 'site,enable,target,pages',
			'rule_type'      => 'exclude',
			'add_rule_label' => __( 'Add Exclusion Rule', 'convertpro' ),
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'category'     => 'Pages',
	),
	/* Geo Location Targeting */
	array(
		'type'         => 'target_geo_rule',
		'class'        => '',
		'name'         => 'target_geo_rule_display',
		'opts'         => array(
			'title'     => __( 'Display Rules', 'convertpro' ),
			'value'     => '[{"type":"basic-all-countries","specific":null}]',
			'tags'      => 'site,enable,target,pages',
			'rule_type' => 'display',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'category'     => 'Geo Location',
	),
	array(
		'type'         => 'target_geo_rule',
		'class'        => '',
		'name'         => 'target_geo_rule_exclude',
		'opts'         => array(
			'title'          => __( 'Exclusion Rules', 'convertpro' ),
			'value'          => '[]',
			'tags'           => 'site,enable,target,pages',
			'rule_type'      => 'exclude',
			'add_rule_label' => __( 'Add Exclusion Rule', 'convertpro' ),
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'category'     => 'Geo Location',
	),
	/* Hide CTA by Cookies */
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'hide_cta_info',
		'opts'         => array(
			/* translators: %s percentage */
			'link'  => sprintf( __( '%s.', 'convertpro' ), '<strong>Enable this if you want to hide this call-to-action when a particular cookie is set</strong>' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Hide CTA Based on Cookies',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'hide_custom_cookies',
		'opts'         => array(
			'title' => '',
			'value' => false,
			'on'    => __( 'YES', 'convertpro' ),
			'off'   => __( 'NO', 'convertpro' ),
			'tags'  => 'custom,enable,cookies,repeat,control,launch,smart',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Hide CTA Based on Cookies',
	),
	array(
		'type'         => 'textfield',
		'class'        => '',
		'name'         => 'hide_cookies_class',
		'opts'         => array(
			'title'       => __( 'Enter cookie name / names that will hide the CTA', 'convertpro' ),
			'value'       => '',
			'description' => __( 'Enter the cookie name or names which when set, you wish to hide this call-to-action.', 'convertpro' ),
			'tags'        => 'enable,cookies,repeat,control,launch,smart',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'dependency'   => array(
			'name'     => 'hide_custom_cookies',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Hide CTA Based on Cookies',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'off_cookie_txt',
		'opts'         => array(
			'link'  => __( 'You can add multiple Cookie names separated by a comma. Ex - firstcookie_name,secondcookie_name,thirdcookie_name', 'convertpro' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'dependency'   => array(
			'name'     => 'hide_custom_cookies',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Hide CTA Based on Cookies',
	),
	/* User Behavior */
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'visitor_info',
		'opts'         => array(
			/* translators: %s percentage */
			'link'  => sprintf( __( '%s.', 'convertpro' ), '<strong>By default it will be shown to all visitors</strong>' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'User Behavior',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'show_for_logged_in',
		'opts'         => array(
			'title'       => __( 'Logged-in Users', 'convertpro' ),
			'value'       => true,
			'on'          => __( 'SHOW', 'convertpro' ),
			'off'         => __( 'HIDE', 'convertpro' ),
			'description' => __( 'Does your website have a login functionality? If yes, do you wish to display this to logged in users?', 'convertpro' ),
			'tags'        => 'disable,exception,target,visitors',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'User Behavior',
	),

	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'show_logged_in_enbl_txt',
		'opts'         => array(
			'link'  => __( 'Logged in users will see this too!', 'convertpro' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'dependency'   => array(
			'name'     => 'show_for_logged_in',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'User Behavior',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'show_logged_in_disbl_txt',
		'opts'         => array(
			'link'  => __( 'Logged in users will not see this.', 'convertpro' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-pages',
		'dependency'   => array(
			'name'     => 'show_for_logged_in',
			'operator' => '!=',
			'value'    => 'true',
		),
		'category'     => 'User Behavior',
	),
	array(
		'type'         => 'checkbox',
		'class'        => '',
		'name'         => 'hide_on_device',
		'opts'         => array(
			'title'       => __( 'Select device on which you wish to hide this call-to-action.', 'convertpro' ),
			'value'       => '',
			'options'     => array(
				__( 'Desktop', 'convertpro' ) => 'desktop',
				__( 'Tablet', 'convertpro' )  => 'tablet',
				__( 'Mobile', 'convertpro' )  => 'mobile',
			),
			'description' => __( 'Select the device/devices you wish to hide this call-to-action on.', 'convertpro' ),
			'tags'        => 'hide,devices,target,visitors',
		),
		'panel'        => 'Target',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-visitor',
		'category'     => 'Hide on Devices',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'cookies_enabled',
		'opts'         => array(
			'title'       => __( 'Do you wish to hide this call-to-action after a visitor closes it or after successful submission?', 'convertpro' ),
			'value'       => true,
			'on'          => __( 'YES', 'convertpro' ),
			'off'         => __( 'NO', 'convertpro' ),
			'description' => __(
				'Decide whether you wish to enable cookies. If enabled, you can hide it from a visitor who has closed it or from the one who has submitted it successfully.
                ',
				'convertpro'
			),
			'tags'        => 'cookies,repeat,control',
		),
		'panel'        => 'Cookies',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'category'     => 'Hide Call-to-action after closing / submission',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'cookies_enabled_enbl',
		'opts'         => array(
			'link'  => __( 'This will not be shown to repeated visitors for the set number of days.', 'convertpro' ),
			'value' => '',
			'title' => '',
			'tags'  => '',
		),
		'panel'        => 'Cookies',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'cookies_enabled',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Hide Call-to-action after closing / submission',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'cookies_enabled',
		'opts'         => array(
			'link'  => __( 'This will be displayed again when the visitor arrives on the website; irrespective of whether he has submitted the form or closed it earlier.', 'convertpro' ),
			'value' => '',
			'title' => '',
			'tags'  => '',
		),
		'panel'        => 'Cookies',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'cookies_enabled',
			'operator' => '!=',
			'value'    => 'true',
		),
		'category'     => 'Hide Call-to-action after closing / submission',
	),
	array(
		'type'         => 'slider',
		'class'        => '',
		'name'         => 'conversion_cookie',
		'opts'         => array(
			'title'       => __( "Hide for 'X' number of days after conversion", 'convertpro' ),
			'value'       => 90,
			'min'         => 0,
			'max'         => 365,
			'step'        => 1,
			'suffix'      => 'days',
			'description' => __( "Select the value of 'X'. This will not be shown for set number of days after conversion.", 'convertpro' ),
			'tags'        => 'cookies,conversion,repeat,control',
		),
		'panel'        => 'Cookies',
		'dependency'   => array(
			'name'     => 'cookies_enabled',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'category'     => 'Hide Call-to-action after closing / submission',
	),
	array(
		'type'         => 'slider',
		'class'        => '',
		'name'         => 'closed_cookie',
		'opts'         => array(
			'title'       => __( "Hide for 'X' number of days after closing", 'convertpro' ),
			'value'       => 30,
			'min'         => 0,
			'max'         => 365,
			'step'        => 1,
			'suffix'      => 'days',
			'description' => __( "Select the value of 'X'. This will not be shown for set number of days after closing.", 'convertpro' ),
			'tags'        => 'cookies,closed,repeat,control',
		),
		'panel'        => 'Cookies',
		'dependency'   => array(
			'name'     => 'cookies_enabled',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-cookies',
		'category'     => 'Hide Call-to-action after closing / submission',
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => '',
		'opts'         => array(
			'link'  => __( 'If you want to set a specific cookie after submission or closing of the call-to-action, you can do that here :', 'convertpro' ),
			'class' => 'cp-cookie-title',
			'value' => '',
			'title' => '',
			'tags'  => '',
		),
		'panel'        => 'Cookies',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'category'     => 'Add specific Cookie name after closing / submission',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'cookies_enabled_submit',
		'opts'         => array(
			'title'       => __( 'Set a cookie after successful submission.', 'convertpro' ),
			'value'       => false,
			'on'          => __( 'YES', 'convertpro' ),
			'off'         => __( 'NO', 'convertpro' ),
			'description' => __(
				'You can add multiple Cookie names separated by a comma. Ex - firstcookie_name,secondcookie_name,thirdcookie_name.',
				'convertpro'
			),
			'tags'        => 'cookies,repeat,control',
		),
		'panel'        => 'Cookies',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'category'     => 'Add specific Cookie name after closing / submission',
	),
	array(
		'type'         => 'textfield',
		'class'        => '',
		'name'         => 'enable_cookies_class_submit',
		'opts'         => array(
			'title'       => __( 'Enter cookie name / names', 'convertpro' ),
			'value'       => '',
			'description' => __( 'Enter the cookie name or names.', 'convertpro' ),
			'tags'        => 'enable,cookies,repeat,control,launch,smart',
		),
		'panel'        => 'Cookies',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'cookies_enabled_submit',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Add specific Cookie name after closing / submission',
	),
	array(
		'type'         => 'slider',
		'class'        => '',
		'name'         => 'conversion_cookie_submit',
		'opts'         => array(
			'title'       => __( "Set for 'X' number of days after conversion", 'convertpro' ),
			'value'       => 90,
			'min'         => 0,
			'max'         => 365,
			'step'        => 1,
			'suffix'      => 'days',
			'description' => __( "Select the value of 'X'. This will not be shown for set number of days after conversion.", 'convertpro' ),
			'tags'        => 'cookies,conversion,repeat,control',
		),
		'panel'        => 'Cookies',
		'dependency'   => array(
			'name'     => 'cookies_enabled_submit',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'category'     => 'Add specific Cookie name after closing / submission',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'cookies_enabled_closed',
		'opts'         => array(
			'title'       => __( 'Set a cookie after visitor closes it.', 'convertpro' ),
			'value'       => false,
			'on'          => __( 'YES', 'convertpro' ),
			'off'         => __( 'NO', 'convertpro' ),
			'description' => __(
				'You can add multiple Cookie names separated by a comma. Ex - firstcookie_name,secondcookie_name,thirdcookie_name.',
				'convertpro'
			),
			'tags'        => 'cookies,repeat,control',
		),
		'panel'        => 'Cookies',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'category'     => 'Add specific Cookie name after closing / submission',
	),
	array(
		'type'         => 'textfield',
		'class'        => '',
		'name'         => 'enable_cookies_class_closed',
		'opts'         => array(
			'title'       => __( 'Enter cookie name / names', 'convertpro' ),
			'value'       => '',
			'description' => __( 'Enter the cookie name or names.', 'convertpro' ),
			'tags'        => 'enable,cookies,repeat,control,launch,smart',
		),
		'panel'        => 'Cookies',
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-launch',
		'dependency'   => array(
			'name'     => 'cookies_enabled_closed',
			'operator' => '==',
			'value'    => 'true',
		),
		'category'     => 'Add specific Cookie name after closing / submission',
	),
	array(
		'type'         => 'slider',
		'class'        => '',
		'name'         => 'closed_cookie_new',
		'opts'         => array(
			'title'       => __( "Set for 'X' number of days after closing", 'convertpro' ),
			'value'       => 30,
			'min'         => 0,
			'max'         => 365,
			'step'        => 1,
			'suffix'      => 'days',
			'description' => __( "Select the value of 'X'. This will not be shown for set number of days after closing.", 'convertpro' ),
			'tags'        => 'cookies,conversion,repeat,control',
		),
		'panel'        => 'Cookies',
		'dependency'   => array(
			'name'     => 'cookies_enabled_closed',
			'operator' => '==',
			'value'    => '1',
		),
		'section'      => 'Configure',
		'section_icon' => 'cp-icon-embed',
		'category'     => 'Add specific Cookie name after closing / submission',
	),
);

$configure = apply_filters( 'cp_configuration_option', $configure );

/****** Submission */
$collect = array(
	array(
		'type'         => 'connect',
		'class'        => '',
		'name'         => 'connect',
		'opts'         => array(
			'title' => __( 'Collect Leads Using', 'convertpro' ),
			'value' => '0',
			'tags'  => 'submission,collect,leads,connect',
		),
		'panel'        => 'Connect',
		'section'      => 'Connect',
		'section_icon' => 'cp-icon-connect',
	),
	array(
		'type'         => 'switch',
		'class'        => '',
		'name'         => 'enable_notification',
		'opts'         => array(
			'title'       => __( 'Enable Email Notification', 'convertpro' ),
			'value'       => true,
			'on'          => __( 'YES', 'convertpro' ),
			'off'         => __( 'NO', 'convertpro' ),
			'description' => __( 'If enabled, all the lead data will be sent to the specified email ID.', 'convertpro' ),
			'tags'        => 'submission,collect,leads,connect',
		),
		'panel'        => 'Email',
		'section'      => 'Connect',
		'section_icon' => 'dashicons dashicons-email-alt',
	),
	array(
		'type'         => 'textfield',
		'class'        => '',
		'name'         => 'custom_email',
		'opts'         => array(
			'title'       => __( 'Enter Email', 'convertpro' ),
			'value'       => get_option( 'admin_email' ),
			'description' => __( 'All the lead data will be sent to this email ID. This happens when you are not connected to any service/mailer.', 'convertpro' ),
			'tags'        => 'submission,collect,leads,connect,email',
		),
		'panel'        => 'Email',
		'section'      => 'Connect',
		'section_icon' => 'dashicons dashicons-email-alt',
		'dependency'   => array(
			'name'     => 'enable_notification',
			'operator' => '==',
			'value'    => '1',
		),
	),
	array(
		'type'         => 'txt-link',
		'class'        => '',
		'name'         => 'email_temp_link',
		'opts'         => array(
			/* translators: %s percentage */
			'link'  => sprintf( __( "You can modify email template <a rel='noopener' target='_blank' href='%s'>here.</a>", 'convertpro' ), CP_V2_Tab_Menu::get_page_url( 'general-settings' ) . '#email-template' ),
			'value' => '',
			'title' => '',
		),
		'panel'        => 'Email',
		'section'      => 'Connect',
		'section_icon' => 'dashicons dashicons-email-alt',
		'dependency'   => array(
			'name'     => 'enable_notification',
			'operator' => '==',
			'value'    => '1',
		),
	),
	array(
		'type'         => 'cp_hidden',
		'class'        => '',
		'name'         => 'map_placeholder',
		'opts'         => array(
			'title'       => '',
			'value'       => -1,
			'description' => '',
			'tags'        => '',
		),
		'panel'        => 'Email',
		'section'      => 'Connect',
		'section_icon' => 'dashicons dashicons-email-alt',
		'dependency'   => array(
			'name'     => 'enable_notification',
			'operator' => '==',
			'value'    => '1',
		),
	),
);

$collect = apply_filters( 'cp_collect_option', $collect );

	/**
	 * Setup the option array for `customizer` for individual modal popup
	 *
	 * @since 1.0.0
	 */

	$cp_framework_inst = new Cp_Framework();

	$cp_framework_inst->cp_framework_add_options(
		array(
			'options' => array_merge(
				$configure,
				$collect
			),
		)
	);

	$icons_array = array(
		'cp-icon-text',
		'cp-icon-cookies',
	);

	/**
	 * Filter for Entry Animation Array
	 *
	 * @param array $animations - animations.
	 */
	function cp_entry_animations_callback( $animations ) {

		$entry_anim_arr = array(
			'cp-none'         => __( 'No Effect', 'convertpro' ),
			'cp-bounce'       => __( 'Bounce', 'convertpro' ),
			'cp-bounceIn'     => __( 'Bounce In', 'convertpro' ),
			'cp-fadeIn'       => __( 'Fade In', 'convertpro' ),
			'cp-fadeInScale'  => __( 'Fade In & Scale', 'convertpro' ),
			'cp-jello'        => __( 'Jello', 'convertpro' ),
			'cp-lightSpeedIn' => __( 'Light Speed In', 'convertpro' ),
			'cp-shake'        => __( 'Shake', 'convertpro' ),
			'cp-slideInDown'  => __( 'Slide In Down', 'convertpro' ),
			'cp-slideInLeft'  => __( 'Slide In Right', 'convertpro' ),
			'cp-slideInRight' => __( 'Slide In Left', 'convertpro' ),
			'cp-slideInUp'    => __( 'Slide In Up', 'convertpro' ),
			'cp-tada'         => __( 'Tada', 'convertpro' ),
		);

		if ( is_array( $animations ) && count( $animations ) > 0 ) {
			$entry_anim_arr = array_merge( $entry_anim_arr, $animations );
		}
		return $entry_anim_arr;
	}
	add_filter( 'cp_entry_animations', 'cp_entry_animations_callback' );

	/**
	 * Filter for Entry Date Format Array
	 *
	 * @param array $date_format - get date formats.
	 */
	function cp_date_format_callback( $date_format ) {

		$entry_date_format_arr = array(
			'MM/DD/YYYY' => __( 'MM/DD/YYYY', 'convertpro' ),
			'MM-DD-YYYY' => __( 'MM-DD-YYYY', 'convertpro' ),
			'DD/MM/YYYY' => __( 'DD/MM/YYYY', 'convertpro' ),
			'DD-MM-YYYY' => __( 'DD-MM-YYYY', 'convertpro' ),
			'YYYY-MM-DD' => __( 'YYYY-MM-DD', 'convertpro' ),
			'MM/DD'      => __( 'MM/DD', 'convertpro' ),
		);

		if ( is_array( $date_format ) && count( $date_format ) > 0 ) {
			$entry_date_format_arr = array_merge( $entry_date_format_arr, $date_format );
		}
		return $entry_date_format_arr;
	}
	add_filter( 'cp_date_format', 'cp_date_format_callback' );

	/**
	 * Filter for Exit Enimation Array
	 *
	 * @param array $animations - animations.
	 */
	function cp_exit_animations_callback( $animations ) {

		$exit_anim_arr = array(
			'cp-fadeOut' => __( 'Fade Out', 'convertpro' ),
		);

		if ( is_array( $animations ) && count( $animations ) > 0 ) {
			$exit_anim_arr = array_merge( $exit_anim_arr, $animations );
		}
		return $exit_anim_arr;
	}
	add_filter( 'cp_exit_animations', 'cp_exit_animations_callback' );

	$border_arr = array(
		'solid'  => __( 'Solid', 'convertpro' ),
		'dotted' => __( 'Dotted', 'convertpro' ),
		'dashed' => __( 'Dashed', 'convertpro' ),
		'none'   => __( 'None', 'convertpro' ),
	);
	// Text transform.
	$text_transform_arr = array(
		'none'       => __( 'None', 'convertpro' ),
		'capitalize' => __( 'Capitalize', 'convertpro' ),
		'uppercase'  => __( 'Uppercase', 'convertpro' ),
		'lowercase'  => __( 'Lowercase', 'convertpro' ),
	);
	// Set default options.
	cp_Framework::$border_options         = $border_arr;
	cp_Framework::$text_transform_options = $text_transform_arr;
	cp_Framework::$icon_options           = $icons_array;

	$close_link_options = array(
		'type'         => 'cp_close_text',
		'class'        => '',
		'name'         => 'cp_close_text',
		'opts'         => array(
			'title'          => __( 'Close Link', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'close, close link',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Text',
				'params' => array(
					array(
						'id'            => 'close_type',
						'name'          => 'close_type',
						'type'          => 'hidden',
						'label'         => __( 'Type', 'convertpro' ),
						'default_value' => 'cp-close-type-text',
						'options'       => array(
							'cp-close-type-text'  => __( 'Text', 'convertpro' ),
							'cp-close-type-image' => __( 'Image', 'convertpro' ),
						),
						'map_style'     => array(
							'parameter' => 'class',
							'unit'      => 'cp-close-type-text cp-close-type-image',
						),
					),
					array(
						'id'            => 'close_link_title',
						'name'          => 'close_link_title',
						'type'          => 'text',
						'label'         => __( 'Enter Text', 'convertpro' ),
						'default_value' => __( 'Close', 'convertpro' ),
						'suffix'        => '',
						'map_style'     => array(
							'parameter' => 'inner_html',
							'target'    => '.cp-target .cp-close-link',
						),
					),
					array(
						'id'            => 'close_font_family',
						'name'          => 'close_font_family',
						'type'          => 'font',
						'label'         => 'Font Family',
						'default_value' => 'inherit:inherit',
						'map_style'     => array(
							'parameter' => 'font-family',
							'target'    => '.cp-target .cp-close-link',
						),
						'dependency'    => array(
							'name'     => 'close_type',
							'operator' => '==',
							'value'    => 'cp-close-type-text',
						),
					),
					array(
						'id'             => 'close_title_size',
						'name'           => 'close_title_size',
						'type'           => 'number',
						'suffix'         => 'px',
						'label'          => __( 'Font Size', 'convertpro' ),
						'default_value'  => '16px',
						'map_style'      => array(
							'parameter' => 'font-size',
							'target'    => '.cp-target .cp-close-link',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'close_line_height',
						'name'           => 'close_line_height',
						'type'           => 'slider',
						'suffix'         => 'em',
						'label'          => __( 'Line Height', 'convertpro' ),
						'min'            => 1,
						'max'            => 3,
						'step'           => 0.01,
						'default_value'  => 1.5,
						'map_style'      => array(
							'parameter' => 'line-height',
							'target'    => '.cp-target .cp-close-link',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'close_letter_spacing',
						'name'           => 'close_letter_spacing',
						'type'           => 'slider',
						'suffix'         => 'px',
						'label'          => __( 'Letter Spacing', 'convertpro' ),
						'min'            => 0,
						'max'            => 20,
						'step'           => 0.01,
						'default_value'  => 0,
						'map_style'      => array(
							'parameter' => 'letter-spacing',
							'target'    => '.cp-target .cp-close-link',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'close_text_align',
						'name'           => 'close_text_align',
						'type'           => 'text_align',
						'label'          => __( 'Text Alignment', 'convertpro' ),
						'default_value'  => 'center',
						'options'        => array(
							'center'  => __( 'center', 'convertpro' ),
							'left'    => __( 'left', 'convertpro' ),
							'right'   => __( 'right', 'convertpro' ),
							'justify' => __( 'justify', 'convertpro' ),
						),
						'map_style'      => array(
							'parameter' => 'text-align',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'            => 'close_link_color',
						'name'          => 'close_link_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Color', 'convertpro' ),
						'default_value' => '#000',
						'map_style'     => array(
							'parameter' => 'color',
							'target'    => '.cp-target .cp-close-link',
						),
					),
					array(
						'id'            => 'close_back_color',
						'name'          => 'close_back_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Background Color', 'convertpro' ),
						'default_value' => '',
						'map_style'     => array(
							'parameter' => 'background',
							'target'    => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 60,
						'min'            => 0,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'target'    => '.cp-target',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'label'          => __( 'Height', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 25,
						'min'            => 0,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'target'    => '.cp-target',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'field_action',
						'name'           => 'field_action',
						'type'           => 'hidden',
						'label'          => 'Field Action',
						'default_value'  => 'close',
						'hide_on_mobile' => true,
						'options'        => array(
							'none'               => __( 'None', 'convertpro' ),
							'submit'             => __( 'Submit', 'convertpro' ),
							'submit_n_goto_step' => __( 'Submit & Go to Step', 'convertpro' ),
							'submit_n_close'     => __( 'Submit & Close', 'convertpro' ),
							'goto_url'           => __( 'Go to URL', 'convertpro' ),
							'goto_step'          => __( 'Go to Step', 'convertpro' ),
							'close'              => __( 'Close', 'convertpro' ),
						),
						'map'            => array(
							'attr'   => 'button-type',
							'target' => '.cp-target',
						),
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'cp-icon-elements',
	);

	$close_link_options = apply_filters( 'cp_close_link_options', $close_link_options );

	$cp_countdown_options = array(
		'type'         => 'cp_countdown',
		'class'        => '',
		'name'         => 'cp_countdown',
		'opts'         => array(
			'title'          => __( 'Countdown', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'countdown,timer,evergreen',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => __( 'Timer', 'convertpro' ),
				'params' => array(
					array(
						'id'             => 'timer_type',
						'name'           => 'timer_type',
						'type'           => 'dropdown',
						'label'          => __( 'Timer Type', 'convertpro' ),
						'default_value'  => 'fixed',
						'hide_on_mobile' => true,
						'options'        => array(
							'fixed'     => __( 'Fixed', 'convertpro' ),
							'evergreen' => __( 'Evergreen', 'convertpro' ),
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),
					array(
						'id'             => 'timer_timezone',
						'name'           => 'timer_timezone',
						'type'           => 'timezone',
						'label'          => __( 'Timer Timezone', 'convertpro' ),
						'zones'          => cpro_build_timezones( array() ),
						'hide_on_mobile' => true,
						'options'        => '',
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'fixed',
						),
					),
					array(
						'id'             => 'display_as',
						'name'           => 'display_as',
						'type'           => 'dropdown',
						'label'          => __( 'Display As', 'convertpro' ),
						'default_value'  => 'block',
						'hide_on_mobile' => true,
						'options'        => array(
							'block'  => __( 'Block', 'convertpro' ),
							'inline' => __( 'Inline', 'convertpro' ),
						),
						'map'            => array(
							'attr'   => 'change-class',
							'target' => '.cp-target',
						),
					),
					array(
						'id'             => 'fixed_year',
						'name'           => 'fixed_year',
						'type'           => 'dropdown',
						'label'          => __( 'Year', 'convertpro' ),
						'default_value'  => '2018',
						'hide_on_mobile' => true,
						'options'        => array(
							'2017' => '2017',
							'2018' => '2018',
							'2019' => '2019',
							'2020' => '2020',
							'2021' => '2021',
							'2022' => '2022',
							'2023' => '2023',
							'2024' => '2024',
							'2025' => '2025',
							'2026' => '2026',
							'2027' => '2027',
							'2028' => '2028',
							'2029' => '2029',
							'2030' => '2030',
							'2031' => '2031',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'fixed',
						),
					),
					array(
						'id'             => 'fixed_month',
						'name'           => 'fixed_month',
						'type'           => 'dropdown',
						'label'          => __( 'Month', 'convertpro' ),
						'default_value'  => '01',
						'hide_on_mobile' => true,
						'options'        => array(
							'01' => 'Jan',
							'02' => 'Feb',
							'03' => 'Mar',
							'04' => 'Apr',
							'05' => 'May',
							'06' => 'Jun',
							'07' => 'Jul',
							'08' => 'Aug',
							'09' => 'Sep',
							'10' => 'Oct',
							'11' => 'Nov',
							'12' => 'Dec',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'fixed',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),
					array(
						'id'             => 'fixed_day',
						'name'           => 'fixed_day',
						'type'           => 'dropdown',
						'label'          => __( 'Day', 'convertpro' ),
						'default_value'  => '26',
						'hide_on_mobile' => true,
						'options'        => array(
							'1'  => '01',
							'2'  => '02',
							'3'  => '03',
							'4'  => '04',
							'5'  => '05',
							'6'  => '06',
							'7'  => '07',
							'8'  => '08',
							'9'  => '09',
							'10' => '10',
							'11' => '11',
							'12' => '12',
							'13' => '13',
							'14' => '14',
							'15' => '15',
							'16' => '16',
							'17' => '17',
							'18' => '18',
							'19' => '19',
							'20' => '20',
							'21' => '21',
							'22' => '22',
							'23' => '23',
							'24' => '24',
							'25' => '25',
							'26' => '26',
							'27' => '27',
							'28' => '28',
							'29' => '29',
							'30' => '30',
							'31' => '31',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'fixed',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),
					array(
						'id'             => 'fixed_hrs',
						'name'           => 'fixed_hrs',
						'type'           => 'dropdown',
						'label'          => __( 'Hours', 'convertpro' ),
						'default_value'  => '0',
						'hide_on_mobile' => true,
						'options'        => array(
							'0'  => '00',
							'1'  => '01',
							'2'  => '02',
							'3'  => '03',
							'4'  => '04',
							'5'  => '05',
							'6'  => '06',
							'7'  => '07',
							'8'  => '08',
							'9'  => '09',
							'10' => '10',
							'11' => '11',
							'12' => '12',
							'13' => '13',
							'14' => '14',
							'15' => '15',
							'16' => '16',
							'17' => '17',
							'18' => '18',
							'19' => '19',
							'20' => '20',
							'21' => '21',
							'22' => '22',
							'23' => '23',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'fixed',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),
					array(
						'id'             => 'fixed_min',
						'name'           => 'fixed_min',
						'type'           => 'dropdown',
						'label'          => __( 'Minutes', 'convertpro' ),
						'default_value'  => '55',
						'hide_on_mobile' => true,
						'options'        => array(
							'0'  => '00',
							'1'  => '01',
							'2'  => '02',
							'3'  => '03',
							'4'  => '04',
							'5'  => '05',
							'6'  => '06',
							'7'  => '07',
							'8'  => '08',
							'9'  => '09',
							'10' => '10',
							'11' => '11',
							'12' => '12',
							'13' => '13',
							'14' => '14',
							'15' => '15',
							'16' => '16',
							'17' => '17',
							'18' => '18',
							'19' => '19',
							'20' => '20',
							'21' => '21',
							'22' => '22',
							'23' => '23',
							'24' => '24',
							'25' => '25',
							'26' => '26',
							'27' => '27',
							'28' => '28',
							'29' => '29',
							'30' => '30',
							'31' => '31',
							'32' => '32',
							'33' => '33',
							'34' => '34',
							'35' => '35',
							'36' => '36',
							'37' => '37',
							'38' => '38',
							'39' => '39',
							'40' => '40',
							'41' => '41',
							'42' => '42',
							'43' => '43',
							'44' => '44',
							'45' => '45',
							'46' => '46',
							'47' => '47',
							'48' => '48',
							'49' => '49',
							'50' => '50',
							'51' => '51',
							'52' => '52',
							'53' => '53',
							'54' => '54',
							'55' => '55',
							'56' => '56',
							'57' => '57',
							'58' => '58',
							'59' => '59',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'fixed',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),
					/* Evergreen Timer Fields */
					array(
						'id'             => 'ever_day',
						'name'           => 'ever_day',
						'type'           => 'dropdown',
						'label'          => __( 'Day', 'convertpro' ),
						'default_value'  => '0',
						'hide_on_mobile' => true,
						'options'        => array(
							'0'  => '00',
							'1'  => '01',
							'2'  => '02',
							'3'  => '03',
							'4'  => '04',
							'5'  => '05',
							'6'  => '06',
							'7'  => '07',
							'8'  => '08',
							'9'  => '09',
							'10' => '10',
							'11' => '11',
							'12' => '12',
							'13' => '13',
							'14' => '14',
							'15' => '15',
							'16' => '16',
							'17' => '17',
							'18' => '18',
							'19' => '19',
							'20' => '20',
							'21' => '21',
							'22' => '22',
							'23' => '23',
							'24' => '24',
							'25' => '25',
							'26' => '26',
							'27' => '27',
							'28' => '28',
							'29' => '29',
							'30' => '30',
							'31' => '31',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'evergreen',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),
					array(
						'id'             => 'ever_hrs',
						'name'           => 'ever_hrs',
						'type'           => 'dropdown',
						'label'          => __( 'Hours', 'convertpro' ),
						'default_value'  => '5',
						'hide_on_mobile' => true,
						'options'        => array(
							'0'  => '00',
							'1'  => '01',
							'2'  => '02',
							'3'  => '03',
							'4'  => '04',
							'5'  => '05',
							'6'  => '06',
							'7'  => '07',
							'8'  => '08',
							'9'  => '09',
							'10' => '10',
							'11' => '11',
							'12' => '12',
							'13' => '13',
							'14' => '14',
							'15' => '15',
							'16' => '16',
							'17' => '17',
							'18' => '18',
							'19' => '19',
							'20' => '20',
							'21' => '21',
							'22' => '22',
							'23' => '23',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'evergreen',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),
					array(
						'id'             => 'ever_min',
						'name'           => 'ever_min',
						'type'           => 'dropdown',
						'label'          => __( 'Minutes', 'convertpro' ),
						'default_value'  => '55',
						'hide_on_mobile' => true,
						'options'        => array(
							'0'  => '00',
							'1'  => '01',
							'2'  => '02',
							'3'  => '03',
							'4'  => '04',
							'5'  => '05',
							'6'  => '06',
							'7'  => '07',
							'8'  => '08',
							'9'  => '09',
							'10' => '10',
							'11' => '11',
							'12' => '12',
							'13' => '13',
							'14' => '14',
							'15' => '15',
							'16' => '16',
							'17' => '17',
							'18' => '18',
							'19' => '19',
							'20' => '20',
							'21' => '21',
							'22' => '22',
							'23' => '23',
							'24' => '24',
							'25' => '25',
							'26' => '26',
							'27' => '27',
							'28' => '28',
							'29' => '29',
							'30' => '30',
							'31' => '31',
							'32' => '32',
							'33' => '33',
							'34' => '34',
							'35' => '35',
							'36' => '36',
							'37' => '37',
							'38' => '38',
							'39' => '39',
							'40' => '40',
							'41' => '41',
							'42' => '42',
							'43' => '43',
							'44' => '44',
							'45' => '45',
							'46' => '46',
							'47' => '47',
							'48' => '48',
							'49' => '49',
							'50' => '50',
							'51' => '51',
							'52' => '52',
							'53' => '53',
							'54' => '54',
							'55' => '55',
							'56' => '56',
							'57' => '57',
							'58' => '58',
							'59' => '59',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'evergreen',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),
					array(
						'id'             => 'ever_sec',
						'name'           => 'ever_sec',
						'type'           => 'dropdown',
						'label'          => __( 'Seconds', 'convertpro' ),
						'default_value'  => '55',
						'hide_on_mobile' => true,
						'options'        => array(
							'0'  => '00',
							'1'  => '01',
							'2'  => '02',
							'3'  => '03',
							'4'  => '04',
							'5'  => '05',
							'6'  => '06',
							'7'  => '07',
							'8'  => '08',
							'9'  => '09',
							'10' => '10',
							'11' => '11',
							'12' => '12',
							'13' => '13',
							'14' => '14',
							'15' => '15',
							'16' => '16',
							'17' => '17',
							'18' => '18',
							'19' => '19',
							'20' => '20',
							'21' => '21',
							'22' => '22',
							'23' => '23',
							'24' => '24',
							'25' => '25',
							'26' => '26',
							'27' => '27',
							'28' => '28',
							'29' => '29',
							'30' => '30',
							'31' => '31',
							'32' => '32',
							'33' => '33',
							'34' => '34',
							'35' => '35',
							'36' => '36',
							'37' => '37',
							'38' => '38',
							'39' => '39',
							'40' => '40',
							'41' => '41',
							'42' => '42',
							'43' => '43',
							'44' => '44',
							'45' => '45',
							'46' => '46',
							'47' => '47',
							'48' => '48',
							'49' => '49',
							'50' => '50',
							'51' => '51',
							'52' => '52',
							'53' => '53',
							'54' => '54',
							'55' => '55',
							'56' => '56',
							'57' => '57',
							'58' => '58',
							'59' => '59',
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'evergreen',
						),
						'map'            => array(
							'attr'   => 'change-date',
							'target' => '.cp-target',
						),
					),

					/* Action after timer end */
					array(
						'id'             => 'fixed_timer_action',
						'name'           => 'fixed_timer_action',
						'type'           => 'dropdown',
						'label'          => __( 'Action After Timer Expiry', 'convertpro' ),
						'default_value'  => 'none',
						'hide_on_mobile' => true,
						'options'        => array(
							'none'       => __( 'None', 'convertpro' ),
							'hide_popup' => __( 'Do not show popup again', 'convertpro' ),
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'fixed',
						),
					),
					array(
						'id'             => 'evergreen_timer_action',
						'name'           => 'evergreen_timer_action',
						'type'           => 'dropdown',
						'label'          => __( 'Action After Timer Expiry', 'convertpro' ),
						'default_value'  => 'none',
						'hide_on_mobile' => true,
						'options'        => array(
							'none'        => __( 'None', 'convertpro' ),
							'hide_popup'  => __( 'Do not show popup again', 'convertpro' ),
							'reset_timer' => __( 'Reset Timer', 'convertpro' ),
						),
						'dependency'     => array(
							'name'     => 'timer_type',
							'operator' => '==',
							'value'    => 'evergreen',
						),
					),
				),
			),
			array(
				'title'  => 'Text',
				'params' => array(
					array(
						'id'             => 'number_font_size',
						'name'           => 'number_font_size',
						'type'           => 'number',
						'suffix'         => 'px',
						'step'           => 1,
						'label'          => __( 'Number Font Size', 'convertpro' ),
						'default_value'  => '30px',
						'map_style'      => array(
							'parameter' => 'countdown_number_font_size',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'text_font_size',
						'name'           => 'text_font_size',
						'type'           => 'number',
						'suffix'         => 'px',
						'step'           => 1,
						'label'          => __( 'Text Font Size', 'convertpro' ),
						'default_value'  => '10px',
						'map_style'      => array(
							'parameter' => 'countdown_text_font_size',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'            => 'number_color',
						'name'          => 'number_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Number Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'countdown_number_color',
						),
					),
					array(
						'id'            => 'countdown_text_color',
						'name'          => 'countdown_text_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Text Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'countdown_text_color',
						),
					),
					array(
						'id'             => 'countdown_text_align',
						'name'           => 'countdown_text_align',
						'type'           => 'text_align',
						'label'          => __( 'Text Alignment', 'convertpro' ),
						'default_value'  => 'center',
						'options'        => array(
							'center'  => __( 'center', 'convertpro' ),
							'left'    => __( 'left', 'convertpro' ),
							'right'   => __( 'right', 'convertpro' ),
							'justify' => __( 'justify', 'convertpro' ),
						),
						'map_style'      => array(
							'parameter' => 'countdown_text_align',
							'target'    => '.cp-target .cp-countdown-holding',
						),
						'show_on_mobile' => true,
					),
				),
			),
			array(
				'title'  => __( 'Design', 'convertpro' ),
				'params' => array(
					array(
						'id'             => 'inside_outside',
						'name'           => 'inside_outside',
						'type'           => 'dropdown',
						'label'          => __( 'Text Inside/Outside of Box', 'convertpro' ),
						'default_value'  => 'outside',
						'hide_on_mobile' => true,
						'options'        => array(
							'inside'  => __( 'Outside', 'convertpro' ),
							'outside' => __( 'Inside', 'convertpro' ),
						),
						'map_style'      => array(
							'parameter' => 'inside_outside',
						),
					),
					array(
						'id'            => 'bg_color',
						'name'          => 'bg_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Background Color', 'convertpro' ),
						'default_value' => '#f4f4f4',
						'map_style'     => array(
							'parameter' => 'countdown_background',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'    => 'label_border',
						'name'  => 'label_border',
						'type'  => 'label',
						'label' => __( 'Border', 'convertpro' ),
					),
					array(
						'id'             => 'countdown_border_style',
						'name'           => 'countdown_border_style',
						'type'           => 'dropdown',
						'hide_on_mobile' => true,
						'label'          => __( 'Border Style', 'convertpro' ),
						'default_value'  => 'none',
						'options'        => array(
							'solid'  => __( 'Solid', 'convertpro' ),
							'dotted' => __( 'Dotted', 'convertpro' ),
							'dashed' => __( 'Dashed', 'convertpro' ),
							'none'   => __( 'None', 'convertpro' ),
						),
						'map_style'      => array(
							'parameter' => 'countdown_border_style',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'countdown_border_color',
						'name'           => 'countdown_border_color',
						'type'           => 'colorpicker',
						'hide_on_mobile' => true,
						'label'          => __( 'Border Color', 'convertpro' ),
						'default_value'  => '#757575',
						'map_style'      => array(
							'parameter' => 'countdown_border_color',
							'target'    => '.cp-target',
						),
						'dependency'     => array(
							'name'     => 'countdown_border_style',
							'operator' => '!=',
							'value'    => 'none',
						),
					),
					array(
						'id'             => 'countdown_border_width',
						'name'           => 'countdown_border_width',
						'type'           => 'multiinput',
						'hide_on_mobile' => true,
						'label'          => __( 'Border Width', 'convertpro' ),
						'suffix'         => 'px',
						'default_value'  => '1|1|1|1|px',
						'map_style'      => array(
							'parameter' => 'countdown_border_width',
							'target'    => '.cp-target',
						),
						'dependency'     => array(
							'name'     => 'countdown_border_style',
							'operator' => '!=',
							'value'    => 'none',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'countdown_border_radius',
						'name'           => 'countdown_border_radius',
						'type'           => 'multiinput',
						'hide_on_mobile' => true,
						'label'          => __( 'Border Radius', 'convertpro' ),
						'suffix'         => 'px',
						'default_value'  => '0|0|0|0|px',
						'map_style'      => array(
							'parameter' => 'countdown_border_radius',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'countdown_field_padding',
						'name'           => 'countdown_field_padding',
						'type'           => 'multiinput',
						'label'          => __( 'Padding', 'convertpro' ),
						'suffix'         => 'px',
						'default_value'  => '15|15|15|15|px',
						'map_style'      => array(
							'parameter' => 'countdown_padding',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'text_space',
						'name'           => 'text_space',
						'label'          => __( 'Space between Text and Number', 'convertpro' ),
						'type'           => 'slider',
						'default_value'  => 6,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'text_space',
							'unit'      => 'px',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'            => 'show_months',
						'name'          => 'show_months',
						'type'          => 'switch',
						'label'         => __( 'Show Months', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'show-hide-countdown',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'show_days',
						'name'          => 'show_days',
						'type'          => 'switch',
						'label'         => __( 'Show Days', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'show-hide-countdown',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'show_hours',
						'name'          => 'show_hours',
						'type'          => 'switch',
						'label'         => __( 'Show Hours', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'show-hide-countdown',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'show_mins',
						'name'          => 'show_mins',
						'type'          => 'switch',
						'label'         => __( 'Show Minutes', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'show-hide-countdown',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'show_seconds',
						'name'          => 'show_seconds',
						'type'          => 'switch',
						'label'         => __( 'Show Seconds', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'show-hide-countdown',
							'target' => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => __( 'Advanced', 'convertpro' ),
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'slider',
						'default_value'  => 450,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'slider',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 105,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'dashicons dashicons-screenoptions',
	);

	$cp_countdown_options = apply_filters( 'cp_countdown_options', $cp_countdown_options );

	$close_image_options = array(
		'type'         => 'cp_close_image',
		'class'        => '',
		'name'         => 'cp_close_image',
		'opts'         => array(
			'title'          => __( 'Image', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'close image,close',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Image',
				'params' => array(
					array(
						'id'            => 'close_image_type',
						'name'          => 'close_image_type',
						'type'          => 'dropdown',
						'label'         => __( 'Image Source', 'convertpro' ),
						'default_value' => 'predefined',
						'options'       => array(
							'upload'     => __( 'Upload Image', 'convertpro' ),
							'predefined' => __( 'Predefined Icons', 'convertpro' ),
						),
						'map_style'     => array(
							'parameter' => 'close-image-type',
						),
					),
					array(
						'id'            => 'module_image',
						'name'          => 'module_image',
						'type'          => 'media',
						'label'         => __( 'Close Image', 'convertpro' ),
						'default_value' => '0|admin/img/close1.png',
						'map'           => array(
							'attr'   => 'src',
							'target' => '.cp-target',
						),
						'source'        => 'upload_img',
						'dependency'    => array(
							'name'     => 'close_image_type',
							'operator' => '==',
							'value'    => 'upload',
						),
					),
					array(
						'id'               => 'module_radio_image',
						'name'             => 'module_radio_image',
						'type'             => 'radio_image',
						'label'            => __( 'Module Image', 'convertpro' ),
						'map'              => array(
							'attr'   => 'src',
							'target' => '.cp-target',
						),
						'map_style'        => array(
							'parameter' => 'radio-image',
						),
						'default_value'    => 'admin/img/close1.png',
						'source'           => 'predefined',
						'default_alt_text' => '',
						'options'          => array(
							'1' => 'admin/img/close1.png',
							'2' => 'admin/img/close2.png',
							'3' => 'admin/img/close3.png',
							'4' => 'admin/img/close4.png',
							'5' => 'admin/img/close5.png',
							'6' => 'admin/img/close6.png',
						),
						'dependency'       => array(
							'name'     => 'close_image_type',
							'operator' => '==',
							'value'    => 'predefined',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 32,
						'min'            => 0,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 32,
						'min'            => 0,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'field_action',
						'name'           => 'field_action',
						'type'           => 'hidden',
						'label'          => 'Field Action',
						'default_value'  => 'close',
						'hide_on_mobile' => true,
						'options'        => array(
							'none'               => 'None',
							'submit'             => 'Submit',
							'submit_n_goto_step' => 'Submit & Go to Step',
							'submit_n_close'     => 'Submit & Close',
							'goto_url'           => 'Go to URL',
							'goto_step'          => 'Go to Step',
							'close'              => 'Close',
						),
						'map'            => array(
							'attr'   => 'button-type',
							'target' => '.cp-target',
						),
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'dashicons dashicons-screenoptions',
	);

	$close_image_options = apply_filters( 'cp_close_image_options', $close_image_options );

	$cp_shapes_options = array(
		'type'         => 'cp_shape',
		'class'        => '',
		'name'         => 'cp_shape',
		'opts'         => array(
			'title'          => __( 'Shape', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'shape,shapes',
			'resize'         => true,
			'show_on_mobile' => false,
			'presets'        => apply_filters( 'cp_shape_presets', array() ),
		),
		'sections'     => array(
			array(
				'title'  => 'Colors',
				'params' => array(
					array(
						'id'            => 'shape_color',
						'name'          => 'shape_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Color', 'convertpro' ),
						'default_value' => '#666666',
						'map_style'     => array(
							'parameter' => 'fill',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'            => 'shape_hover_color',
						'name'          => 'shape_hover_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Hover Color', 'convertpro' ),
						'default_value' => '',
						'map_style'     => array(
							'parameter' => 'fill',
							'target'    => '.cp-target',
							'onhover'   => true,
						),
					),
					array(
						'id'            => 'shape_width',
						'name'          => 'shape_width',
						'label'         => __( 'Border Thickness', 'convertpro' ),
						'type'          => 'slider',
						'default_value' => 2,
						'min'           => 1,
						'max'           => 10,
						'step'          => 1,
						'suffix'        => 'px',
						'map_style'     => array(
							'parameter' => 'stroke-width',
							'target'    => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Action',
				'params' => array(
					array(
						'id'             => 'field_action',
						'name'           => 'field_action',
						'type'           => 'dropdown',
						'label'          => 'Manage shape action',
						'default_value'  => 'none',
						'hide_on_mobile' => true,
						'options'        => array(
							'none'               => __( 'None', 'convertpro' ),
							'submit'             => __( 'Submit', 'convertpro' ),
							'submit_n_goto_step' => __( 'Submit & Go to Step', 'convertpro' ),
							'submit_n_goto_url'  => __( 'Submit & Go to URL', 'convertpro' ),
							'submit_n_close'     => __( 'Submit & Close', 'convertpro' ),
							'goto_url'           => __( 'Go to URL', 'convertpro' ),
							'goto_step'          => __( 'Go to Step', 'convertpro' ),
							'close'              => __( 'Close', 'convertpro' ),
							'close_tab'          => __( 'Close Page', 'convertpro' ),
							'close_n_goto_url'   => __( 'Close & Go to URL', 'convertpro' ),
						),
						'map'            => array(
							'attr'   => 'button-type',
							'target' => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'    => 'label_box_shadow',
						'name'  => 'label_box_shadow',
						'type'  => 'label',
						'label' => __( 'Shadow', 'convertpro' ),
					),
					array(
						'id'             => 'field_box_shadow',
						'name'           => 'field_box_shadow',
						'type'           => 'box_shadow',
						'hide_on_mobile' => true,
						'suffix'         => '',
						'label'          => 'Shadow',
						'drop_shadow'    => 'drop-shadow',
						'default_value'  => 'type:none|horizontal:0|vertical:0|blur:5|spread:0|color:rgba(86,86,131,0.6)',
						'options'        => array(
							'none'   => __( 'None', 'convertpro' ),
							'outset' => __( 'Outset', 'convertpro' ),
						),
						'map_style'      => array(
							'parameter' => 'box_shadow',
							'target'    => '.cp-target,.cp-target ~ .cp-field-shadow',
						),
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 50,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 50,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Shapes',
		'section'      => 'Design',
		'section_icon' => 'cp-icon-shapes',
	);

	$cp_shapes_options = apply_filters( 'cp_shapes_options', $cp_shapes_options );

	$cp_image_options = array(
		'type'         => 'cp_image',
		'class'        => '',
		'name'         => 'cp_image',
		'opts'         => array(
			'title'          => __( 'Image', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'image,picture',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Image',
				'params' => array(
					array(
						'id'               => 'module_image',
						'name'             => 'module_image',
						'type'             => 'media',
						'label'            => __( 'Module Image', 'convertpro' ),
						'default_value'    => '0|modules/img/default-image.png',
						'map'              => array(
							'attr'   => 'src',
							'target' => '.cp-target',
						),
						'source'           => 'upload_img', // for custom source should be custom_img.
						'default_alt_text' => '',
						'custom_url'       => '',
					),
				),
			),
			array(
				'title' => 'Text',
			),
			array(
				'title'  => 'Action',
				'params' => array(
					array(
						'id'             => 'field_action',
						'name'           => 'field_action',
						'type'           => 'dropdown',
						'label'          => 'Field Action',
						'default_value'  => 'none',
						'hide_on_mobile' => true,
						'options'        => array(
							'none'      => __( 'None', 'convertpro' ),
							'goto_url'  => __( 'Go to URL', 'convertpro' ),
							'goto_step' => __( 'Go to Step', 'convertpro' ),
							'close'     => __( 'Close', 'convertpro' ),
						),
						'map'            => array(
							'attr'   => 'button-type',
							'target' => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => 'Width',
						'type'           => 'number',
						'default_value'  => 128,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => 'Height',
						'default_value'  => 128,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'dashicons dashicons-screenoptions',
	);

	$cp_image_options = apply_filters( 'cp_image_options', $cp_image_options );

	$cp_custom_html_options = array(
		'type'         => 'cp_custom_html',
		'class'        => '',
		'name'         => 'cp_custom_html',
		'opts'         => array(
			'title'          => __( 'Custom HTML', 'convertpro' ),
			'value'          => __( 'This is custom <b>HTML</b>. Edit this text from left side panel.', 'convertpro' ),
			'description'    => '',
			'tags'           => 'html, custom html',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Text',
				'params' => array(
					array(
						'id'            => 'custom_html_content',
						'name'          => 'custom_html_content',
						'type'          => 'textarea',
						'rows'          => '12',
						'label'         => __( 'Enter HTML', 'convertpro' ),
						'default_value' => __( 'This is custom <b>HTML</b>. Edit this text from left side panel.', 'convertpro' ),
						'map_style'     => array(
							'parameter' => 'inner_html',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => 'Width',
						'type'           => 'number',
						'default_value'  => 210,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => 'Height',
						'default_value'  => 50,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'cp-icon-text',
	);

	$cp_custom_html_options = apply_filters( 'cp_custom_html_options', $cp_custom_html_options );

	$cp_paragraph_options = array(
		'type'         => 'cp_paragraph',
		'class'        => '',
		'name'         => 'cp_paragraph',
		'opts'         => array(
			'title'          => __( 'Paragraph', 'convertpro' ),
			'value'          => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla quam velit, vulputate eu pharetra nec, mattis ac neque. Duis vulputate commodo lectus, ac blandit elit tincidunt id.',
			'description'    => '',
			'tags'           => 'paragraph',
			'resize'         => true,
			'editor'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Text',
				'params' => array(
					array(
						'id'              => 'text_content',
						'name'            => 'text_content',
						'type'            => 'hidden',
						'suffix'          => '',
						'label'           => __( 'Title', 'convertpro' ),
						'default_value'   => __( 'Enter Heading', 'convertpro' ),
						'has_tiny_editor' => true,
						'map_style'       => array(
							'parameter' => 'inner_html',
							'target'    => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'font_family',
						'name'          => 'font_family',
						'type'          => 'font',
						'label'         => 'Font Family',
						'default_value' => 'inherit:inherit',
						'map_style'     => array(
							'parameter' => 'font-family',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'             => 'font_size',
						'name'           => 'font_size',
						'type'           => 'number',
						'suffix'         => 'px',
						'step'           => 1,
						'label'          => __( 'Font Size', 'convertpro' ),
						'default_value'  => '14px',
						'map_style'      => array(
							'parameter' => 'font-size',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'line_height',
						'name'           => 'line_height',
						'type'           => 'slider',
						'suffix'         => 'em',
						'label'          => __( 'Line Height', 'convertpro' ),
						'min'            => 1,
						'max'            => 3,
						'step'           => 0.01,
						'default_value'  => 1.6,
						'map_style'      => array(
							'parameter' => 'line-height',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'letter_spacing',
						'name'           => 'letter_spacing',
						'type'           => 'slider',
						'suffix'         => 'px',
						'label'          => __( 'Letter Spacing', 'convertpro' ),
						'min'            => 0,
						'max'            => 20,
						'step'           => 0.01,
						'default_value'  => 0,
						'map_style'      => array(
							'parameter' => 'letter-spacing',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'btn_text_align',
						'name'           => 'btn_text_align',
						'type'           => 'text_align',
						'label'          => __( 'Text Alignment', 'convertpro' ),
						'options'        => array(
							'center'  => __( 'center', 'convertpro' ),
							'left'    => __( 'left', 'convertpro' ),
							'right'   => __( 'right', 'convertpro' ),
							'justify' => __( 'justify', 'convertpro' ),
						),
						'default_value'  => 'left',
						'map_style'      => array(
							'parameter' => 'text-align',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'            => 'text_color',
						'name'          => 'text_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'color',
						),
					),

				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Layout', 'convertpro' ),
						'type'           => 'label',
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 335,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 110,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'cp-icon-text',
	);

	$cp_paragraph_options = apply_filters( 'cp_paragraph_options', $cp_paragraph_options );

	$cp_subheading_options = array(
		'type'         => 'cp_sub_heading',
		'class'        => '',
		'name'         => 'cp_sub_heading',
		'opts'         => array(
			'title'          => __( 'Subheading', 'convertpro' ),
			'value'          => 'Subheading',
			'description'    => '',
			'tags'           => 'subheading',
			'resize'         => true,
			'editor'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Text',
				'params' => array(
					array(
						'id'              => 'text_content',
						'name'            => 'text_content',
						'type'            => 'hidden',
						'suffix'          => '',
						'label'           => __( 'Title', 'convertpro' ),
						'default_value'   => __( 'Enter Heading', 'convertpro' ),
						'has_tiny_editor' => true,
						'map_style'       => array(
							'parameter' => 'inner_html',
							'target'    => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'font_family',
						'name'          => 'font_family',
						'type'          => 'font',
						'label'         => 'Font Family',
						'default_value' => 'inherit:inherit',
						'map_style'     => array(
							'parameter' => 'font-family',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'             => 'font_size',
						'name'           => 'font_size',
						'type'           => 'number',
						'suffix'         => 'px',
						'step'           => 1,
						'label'          => __( 'Font Size', 'convertpro' ),
						'default_value'  => '24px',
						'map_style'      => array(
							'parameter' => 'font-size',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'line_height',
						'name'           => 'line_height',
						'type'           => 'slider',
						'suffix'         => 'em',
						'label'          => __( 'Line Height', 'convertpro' ),
						'min'            => 1,
						'max'            => 3,
						'step'           => 0.01,
						'default_value'  => 1.3,
						'map_style'      => array(
							'parameter' => 'line-height',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'letter_spacing',
						'name'           => 'letter_spacing',
						'type'           => 'slider',
						'suffix'         => 'px',
						'label'          => __( 'Letter Spacing', 'convertpro' ),
						'min'            => 0,
						'max'            => 20,
						'step'           => 0.01,
						'default_value'  => 0,
						'map_style'      => array(
							'parameter' => 'letter-spacing',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'btn_text_align',
						'name'           => 'btn_text_align',
						'type'           => 'text_align',
						'label'          => __( 'Text Alignment', 'convertpro' ),
						'options'        => array(
							'center'  => __( 'center', 'convertpro' ),
							'left'    => __( 'left', 'convertpro' ),
							'right'   => __( 'right', 'convertpro' ),
							'justify' => __( 'justify', 'convertpro' ),
						),
						'default_value'  => 'center',
						'map_style'      => array(
							'parameter' => 'text-align',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'            => 'text_color',
						'name'          => 'text_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'color',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Layout', 'convertpro' ),
						'type'           => 'label',
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'hidden',
						'default_value'  => 144,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'hidden',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 32,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'cp-icon-text',
	);

	$cp_subheading_options = apply_filters( 'cp_subheading_options', $cp_subheading_options );

	$cp_heading_options = array(
		'type'         => 'cp_heading',
		'class'        => '',
		'name'         => 'cp_heading',
		'opts'         => array(
			'title'          => __( 'Heading', 'convertpro' ),
			'value'          => 'Heading',
			'description'    => '',
			'tags'           => 'heading',
			'resize'         => true,
			'editor'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Text',
				'params' => array(
					array(
						'id'              => 'text_content',
						'name'            => 'text_content',
						'type'            => 'hidden',
						'label'           => __( 'Title', 'convertpro' ),
						'default_value'   => __( 'Enter Heading', 'convertpro' ),
						'has_tiny_editor' => true,
						'map_style'       => array(
							'parameter' => 'inner_html',
							'target'    => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'font_family',
						'name'          => 'font_family',
						'type'          => 'font',
						'label'         => 'Font Family',
						'default_value' => 'inherit:inherit',
						'map_style'     => array(
							'parameter' => 'font-family',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'             => 'font_size',
						'name'           => 'font_size',
						'type'           => 'number',
						'suffix'         => 'px',
						'step'           => 1,
						'label'          => __( 'Font Size', 'convertpro' ),
						'default_value'  => '36px',
						'map_style'      => array(
							'parameter' => 'font-size',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,

					),
					array(
						'id'             => 'line_height',
						'name'           => 'line_height',
						'type'           => 'slider',
						'suffix'         => 'em',
						'label'          => __( 'Line Height', 'convertpro' ),
						'min'            => 1,
						'max'            => 3,
						'step'           => 0.01,
						'default_value'  => 1.2,
						'map_style'      => array(
							'parameter' => 'line-height',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'letter_spacing',
						'name'           => 'letter_spacing',
						'type'           => 'slider',
						'suffix'         => 'px',
						'label'          => __( 'Letter Spacing', 'convertpro' ),
						'min'            => 0,
						'max'            => 20,
						'step'           => 0.01,
						'default_value'  => 0,
						'map_style'      => array(
							'parameter' => 'letter-spacing',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'btn_text_align',
						'name'           => 'btn_text_align',
						'type'           => 'text_align',
						'label'          => __( 'Text Alignment', 'convertpro' ),
						'options'        => array(
							'center'  => __( 'center', 'convertpro' ),
							'left'    => __( 'left', 'convertpro' ),
							'right'   => __( 'right', 'convertpro' ),
							'justify' => __( 'justify', 'convertpro' ),
						),
						'default_value'  => 'center',
						'map_style'      => array(
							'parameter' => 'text-align',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'            => 'text_color',
						'name'          => 'text_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'color',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Layout', 'convertpro' ),
						'type'           => 'label',
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'hidden',
						'default_value'  => 148,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'hidden',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 46,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'cp-icon-text',
	);

	$cp_heading_options = apply_filters( 'cp_heading_options', $cp_heading_options );

	$cp_form_email_options = array(
		'type'         => 'cp_email',
		'class'        => '',
		'name'         => 'cp_email',
		'opts'         => array(
			'title'          => __( 'Email', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,email,form fields',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'            => 'email_text_placeholder',
						'name'          => 'email_text_placeholder',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => __( 'Email', 'convertpro' ),
						'map'           => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'label_as_placeholder',
						'name'          => 'label_as_placeholder',
						'type'          => 'switch',
						'label'         => __( 'Name as a Placeholder', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'label-as-placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'required',
						'name'          => 'required',
						'type'          => 'switch',
						'label'         => __( 'Required', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'required',
							'target' => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'    => 'label_animation_email',
						'name'  => 'label_animation_email',
						'type'  => 'label',
						'label' => __( 'Animation', 'convertpro' ),
					),
					array(
						'id'            => 'field_animation',
						'name'          => 'field_animation',
						'type'          => 'dropdown',
						'label'         => 'Animation',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_entry_animations', array() ),
						'map'           => array(
							'attr'   => 'data-anim-class',
							'target' => '.cp-field-html-data',
						),
						'map_style'     => array(
							'parameter' => 'removeAnimClass',
							'target'    => '.cp-field-html-data',
							'unit'      => 'data-anim-class',
						),
					),
					array(
						'id'            => 'field_animation_delay',
						'name'          => 'field_animation_delay',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Delay',
						'default_value' => '0ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-delay',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'field_animation_duration',
						'name'          => 'field_animation_duration',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Duration',
						'default_value' => '1000ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-duration',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'    => 'label_layout_email',
						'name'  => 'label_layout_email',
						'type'  => 'label',
						'label' => __( 'Size', 'convertpro' ),
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 230,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 45,
						'min'            => 1,
						'max'            => 200,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_email_options = apply_filters( 'cp_form_email_options', $cp_form_email_options );

	$cp_form_name_options = array(
		'type'         => 'cp_text',
		'class'        => '',
		'name'         => 'cp_text',
		'opts'         => array(
			'title'          => __( 'Name', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,text,textbox,form fields',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'            => 'input_text_name',
						'name'          => 'input_text_name',
						'type'          => 'hidden',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => 'textfield',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_text_placeholder',
						'name'          => 'input_text_placeholder',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => __( 'Name', 'convertpro' ),
						'map'           => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'label_as_placeholder',
						'name'          => 'label_as_placeholder',
						'type'          => 'switch',
						'label'         => __( 'Name as a Placeholder', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'label-as-placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'required',
						'name'          => 'required',
						'type'          => 'switch',
						'label'         => __( 'Required', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'required',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'reg_ex_validation',
						'name'          => 'reg_ex_validation',
						'type'          => 'switch',
						'label'         => __( 'Enable Validation', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'description'   => __( 'Do you wish to Enable the validation?', 'convertpro' ),
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'input_reg_pattern',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_reg_ex_text',
						'name'          => 'input_reg_ex_text',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Enter the Regular Expression', 'convertpro' ),
						'default_value' => '[A-Za-z\s]+',
						'dependency'    => array(
							'name'     => 'reg_ex_validation',
							'operator' => '==',
							'value'    => 'true',
						),
						'map'           => array(
							'attr'   => 'pattern',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_reg_ex_title',
						'name'          => 'input_reg_ex_title',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Enter the Message Title', 'convertpro' ),
						'default_value' => __( 'Enter the Name', 'convertpro' ),
						'dependency'    => array(
							'name'     => 'reg_ex_validation',
							'operator' => '==',
							'value'    => 'true',
						),
						'map'           => array(
							'attr'   => 'title',
							'target' => '.cp-target',
						),
					),
					array(
						'id'         => 'reg_ex_validation_link',
						'name'       => 'reg_ex_validation_link',
						'class'      => 'cpro-reg-ex-validation-link',
						'type'       => 'label',
						'label'      => /* translators:%s module name .*/
						sprintf( __( '%s ', 'convertpro' ), $form_validation_link ), // PHPCS:ignore WordPress.WP.I18n.NoEmptyStrings,
						'dependency' => array(
							'name'     => 'reg_ex_validation',
							'operator' => '==',
							'value'    => 'true',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'    => 'label_anim_text',
						'name'  => 'label_anim_text',
						'type'  => 'label',
						'label' => __( 'Animation', 'convertpro' ),
					),
					array(
						'id'            => 'field_animation',
						'name'          => 'field_animation',
						'type'          => 'dropdown',
						'label'         => 'Animation',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_entry_animations', array() ),
						'map'           => array(
							'attr'   => 'data-anim-class',
							'target' => '.cp-field-html-data',
						),
						'map_style'     => array(
							'parameter' => 'removeAnimClass',
							'target'    => '.cp-field-html-data',
							'unit'      => 'data-anim-class',
						),
					),
					array(
						'id'            => 'field_animation_delay',
						'name'          => 'field_animation_delay',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Delay',
						'default_value' => '0ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-delay',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'field_animation_duration',
						'name'          => 'field_animation_duration',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Duration',
						'default_value' => '1000ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-duration',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'             => 'label_layout_text',
						'name'           => 'label_layout_text',
						'type'           => 'label',
						'label'          => __( 'Size', 'convertpro' ),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 230,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 45,
						'min'            => 1,
						'max'            => 200,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_name_options = apply_filters( 'cp_form_name_options', $cp_form_name_options );

	$cp_form_phone_options = array(
		'type'         => 'cp_number',
		'class'        => '',
		'name'         => 'cp_number',
		'opts'         => array(
			'title'          => __( 'Phone', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,form fields,number',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'            => 'input_text_name',
						'name'          => 'input_text_name',
						'type'          => 'hidden',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => 'numberfield',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_text_placeholder',
						'name'          => 'input_text_placeholder',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => __( 'Phone', 'convertpro' ),
						'map'           => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'label_as_placeholder',
						'name'          => 'label_as_placeholder',
						'type'          => 'switch',
						'label'         => __( 'Name as a Placeholder', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'label-as-placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'required',
						'name'          => 'required',
						'type'          => 'switch',
						'label'         => __( 'Required', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'required',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'reg_ex_validation',
						'name'          => 'reg_ex_validation',
						'type'          => 'switch',
						'label'         => __( 'Enable Validation', 'convertpro' ),
						'description'   => __( 'Do you wish to Enable the validation?', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'pattern',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_reg_ex_text',
						'name'          => 'input_reg_ex_text',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Enter the Regular Expression', 'convertpro' ),
						'default_value' => __( '[0-9]{10}', 'convertpro' ),
						'dependency'    => array(
							'name'     => 'reg_ex_validation',
							'operator' => '==',
							'value'    => 'true',
						),
						'map'           => array(
							'attr'   => 'input_reg_pattern',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_reg_ex_title',
						'name'          => 'input_reg_ex_title',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Enter the Message Title', 'convertpro' ),
						'default_value' => __( 'Enter the Number.', 'convertpro' ),
						'dependency'    => array(
							'name'     => 'reg_ex_validation',
							'operator' => '==',
							'value'    => 'true',
						),
						'map'           => array(
							'attr'   => 'title',
							'target' => '.cp-target',
						),
					),
					array(
						'id'         => 'reg_ex_validation_link',
						'name'       => 'reg_ex_validation_link',
						'class'      => 'cpro-reg-ex-validation-link',
						'type'       => 'label',
						'label'      => /* translators:%s module name .*/
						sprintf( __( '%s ', 'convertpro' ), $form_validation_link ), // PHPCS:ignore WordPress.WP.I18n.NoEmptyStrings,
						'dependency' => array(
							'name'     => 'reg_ex_validation',
							'operator' => '==',
							'value'    => 'true',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'    => 'label_anim_number',
						'name'  => 'label_anim_number',
						'type'  => 'label',
						'label' => __( 'Animation', 'convertpro' ),
					),
					array(
						'id'            => 'field_animation',
						'name'          => 'field_animation',
						'type'          => 'dropdown',
						'label'         => 'Animation',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_entry_animations', array() ),
						'map'           => array(
							'attr'   => 'data-anim-class',
							'target' => '.cp-field-html-data',
						),
						'map_style'     => array(
							'parameter' => 'removeAnimClass',
							'target'    => '.cp-field-html-data',
							'unit'      => 'data-anim-class',
						),
					),
					array(
						'id'            => 'field_animation_delay',
						'name'          => 'field_animation_delay',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Delay',
						'default_value' => '0ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-delay',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'field_animation_duration',
						'name'          => 'field_animation_duration',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Duration',
						'default_value' => '1000ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-duration',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'             => 'label_layout_number',
						'name'           => 'label_layout_number',
						'type'           => 'label',
						'label'          => __( 'Size', 'convertpro' ),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 230,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 45,
						'min'            => 1,
						'max'            => 200,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_phone_options = apply_filters( 'cp_form_phone_options', $cp_form_phone_options );

	$cp_form_dropdown_options = array(
		'type'         => 'cp_dropdown',
		'class'        => '',
		'name'         => 'cp_dropdown',
		'opts'         => array(
			'title'          => __( 'Dropdown', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,form fields,dropdown',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'            => 'dropdown_name',
						'name'          => 'dropdown_name',
						'type'          => 'hidden',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => 'dropdownfield',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_text_placeholder',
						'name'          => 'input_text_placeholder',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => 'Placeholder text',
						'map'           => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'label_as_placeholder',
						'name'          => 'label_as_placeholder',
						'type'          => 'switch',
						'label'         => __( 'Name as a Placeholder', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'label-as-placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'dropdown_options',
						'name'          => 'dropdown_options',
						'type'          => 'textarea',
						'label'         => __( 'Options', 'convertpro' ),
						'default_value' => "Option1\nOption2\nOption3",
						'suffix'        => '',
						'map_style'     => array(
							'parameter' => 'dropdown-options',
						),
					),
					array(
						'id'            => 'required',
						'name'          => 'required',
						'type'          => 'switch',
						'label'         => __( 'Required', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'required',
							'target' => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'    => 'label_anim_dropdown',
						'name'  => 'label_anim_dropdown',
						'type'  => 'label',
						'label' => __( 'Animation', 'convertpro' ),
					),
					array(
						'id'            => 'field_animation',
						'name'          => 'field_animation',
						'type'          => 'dropdown',
						'label'         => 'Animation',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_entry_animations', array() ),
						'map'           => array(
							'attr'   => 'data-anim-class',
							'target' => '.cp-field-html-data',
						),
						'map_style'     => array(
							'parameter' => 'removeAnimClass',
							'target'    => '.cp-field-html-data',
							'unit'      => 'data-anim-class',
						),
					),
					array(
						'id'            => 'field_animation_delay',
						'name'          => 'field_animation_delay',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Delay',
						'default_value' => '0ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-delay',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'field_animation_duration',
						'name'          => 'field_animation_duration',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Duration',
						'default_value' => '1000ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-duration',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'             => 'label_layout_dropdown',
						'name'           => 'label_layout_dropdown',
						'type'           => 'label',
						'label'          => __( 'Size', 'convertpro' ),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 230,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 45,
						'min'            => 1,
						'max'            => 200,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_dropdown_options = apply_filters( 'cp_form_dropdown_options', $cp_form_dropdown_options );

	$cp_form_textarea_options = array(
		'type'         => 'cp_textarea',
		'class'        => '',
		'name'         => 'cp_textarea',
		'opts'         => array(
			'title'          => __( 'Textarea', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,form fields,textarea',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'            => 'input_text_name',
						'name'          => 'input_text_name',
						'type'          => 'hidden',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => 'textarea',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_text_placeholder',
						'name'          => 'input_text_placeholder',
						'type'          => 'text',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => __( 'Enter message here', 'convertpro' ),
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'label_as_placeholder',
						'name'          => 'label_as_placeholder',
						'type'          => 'switch',
						'label'         => __( 'Name as a Placeholder', 'convertpro' ),
						'suffix'        => '',
						'default_value' => true,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'label-as-placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'required',
						'name'          => 'required',
						'type'          => 'switch',
						'label'         => __( 'Required', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'required',
							'target' => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'    => 'label_anim_textarea',
						'name'  => 'label_anim_textarea',
						'type'  => 'label',
						'label' => __( 'Animation', 'convertpro' ),
					),
					array(
						'id'            => 'field_animation',
						'name'          => 'field_animation',
						'type'          => 'dropdown',
						'label'         => 'Animation',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_entry_animations', array() ),
						'map'           => array(
							'attr'   => 'data-anim-class',
							'target' => '.cp-field-html-data',
						),
						'map_style'     => array(
							'parameter' => 'removeAnimClass',
							'target'    => '.cp-field-html-data',
							'unit'      => 'data-anim-class',
						),
					),
					array(
						'id'            => 'field_animation_delay',
						'name'          => 'field_animation_delay',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Delay',
						'default_value' => '0ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-delay',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'field_animation_duration',
						'name'          => 'field_animation_duration',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Duration',
						'default_value' => '1000ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-duration',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'    => 'label_layout_textarea',
						'name'  => 'label_layout_textarea',
						'type'  => 'label',
						'label' => __( 'Size', 'convertpro' ),
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 230,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 120,
						'min'            => 1,
						'max'            => 300,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'textarea_padding',
						'name'           => 'textarea_padding',
						'type'           => 'multiinput',
						'label'          => __( 'Padding', 'convertpro' ),
						'suffix'         => 'px',
						'default_value'  => '10|10|0|10|px',
						'map_style'      => array(
							'parameter' => 'padding',
							'unit'      => 'px',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_textarea_options = apply_filters( 'cp_form_textarea_options', $cp_form_textarea_options );

	$cp_form_radio_options = array(
		'type'         => 'cp_radio',
		'class'        => '',
		'name'         => 'cp_radio',
		'opts'         => array(
			'title'          => __( 'Radio', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,form fields,radio,radio button',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'            => 'radio_name',
						'name'          => 'radio_name',
						'type'          => 'hidden',
						'label'         => __( 'Radio', 'convertpro' ),
						'default_value' => 'radiofield',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_text_placeholder',
						'name'          => 'input_text_placeholder',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => __( 'Placeholder text', 'convertpro' ),
						'map'           => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'radio_options',
						'name'          => 'radio_options',
						'type'          => 'textarea',
						'label'         => __( 'Options', 'convertpro' ),
						'default_value' => "Option1\nOption2\nOption3",
						'suffix'        => '',
						'map_style'     => array(
							'parameter' => 'radio-options',
						),
					),
					array(
						'id'            => 'required',
						'name'          => 'required',
						'type'          => 'switch',
						'label'         => __( 'Required', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'required',
							'target' => '.cp-target',
						),
					),
					array(
						'id'        => 'radio_orientation',
						'name'      => 'radio_orientation',
						'type'      => 'dropdown',
						'class'     => '',
						'label'     => __( 'Radio Button Orientation', 'convertpro' ),
						'value'     => 'cp-vertical-orien',
						'options'   => array(
							'cp-vertical-orien'   => __( 'Vertical', 'convertpro' ),
							'cp-horizontal-orien' => __( 'Horizontal', 'convertpro' ),
						),
						'map_style' => array(
							'parameter' => 'radio-orientation',
						),
						'tags'      => 'orientation',
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'    => 'label_anim_radio',
						'name'  => 'label_anim_radio',
						'type'  => 'label',
						'label' => __( 'Animation', 'convertpro' ),
					),
					array(
						'id'            => 'field_animation',
						'name'          => 'field_animation',
						'type'          => 'dropdown',
						'label'         => 'Animation',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_entry_animations', array() ),
						'map'           => array(
							'attr'   => 'data-anim-class',
							'target' => '.cp-field-html-data',
						),
						'map_style'     => array(
							'parameter' => 'removeAnimClass',
							'target'    => '.cp-field-html-data',
							'unit'      => 'data-anim-class',
						),
					),
					array(
						'id'            => 'field_animation_delay',
						'name'          => 'field_animation_delay',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Delay',
						'default_value' => '0ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-delay',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'field_animation_duration',
						'name'          => 'field_animation_duration',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Duration',
						'default_value' => '1000ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-duration',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'             => 'label_layout_radio',
						'name'           => 'label_layout_radio',
						'type'           => 'label',
						'label'          => __( 'Size', 'convertpro' ),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 105,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 80,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'radio_size',
						'name'           => 'radio_size',
						'type'           => 'number',
						'label'          => __( 'Radio Size', 'convertpro' ),
						'default_value'  => 16,
						'min'            => 16,
						'max'            => 100,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'radio-size',
							'target'    => '.cp-target .cp-radio-wrap input[type=radio]',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_radio_options = apply_filters( 'cp_form_radio_options', $cp_form_radio_options );

	$cp_form_checkbox_options = array(
		'type'         => 'cp_checkbox',
		'class'        => '',
		'name'         => 'cp_checkbox',
		'opts'         => array(
			'title'          => __( 'Check Box', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,form fields,checkbox',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'            => 'checkbox_name',
						'name'          => 'checkbox_name',
						'type'          => 'hidden',
						'label'         => __( 'Check Box', 'convertpro' ),
						'default_value' => 'checkboxfield',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'input_text_placeholder',
						'name'          => 'input_text_placeholder',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Label', 'convertpro' ),
						'default_value' => __( 'Placeholder text', 'convertpro' ),
						'map'           => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'checkbox_options',
						'name'          => 'checkbox_options',
						'type'          => 'textarea',
						'label'         => __( 'Options', 'convertpro' ),
						'default_value' => "Option1\nOption2\nOption3",
						'suffix'        => '',
						'map_style'     => array(
							'parameter' => 'checkbox-options',
						),
					),
					array(
						'id'            => 'required',
						'name'          => 'required',
						'type'          => 'switch',
						'label'         => __( 'Required', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'required',
							'target' => '.cp-target',
						),
					),
					array(
						'id'        => 'checkbox_orientation',
						'name'      => 'checkbox_orientation',
						'type'      => 'dropdown',
						'class'     => '',
						'label'     => __( 'Checkbox Button Orientation', 'convertpro' ),
						'value'     => 'cp-vertical-orien',
						'options'   => array(
							'cp-vertical-orien'   => __( 'Vertical', 'convertpro' ),
							'cp-horizontal-orien' => __( 'Horizontal', 'convertpro' ),
						),
						'map_style' => array(
							'parameter' => 'checkbox-orientation',
						),
						'tags'      => 'orientation',
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'label_line_height',
						'name'           => 'label_line_height',
						'type'           => 'number',
						'label'          => __( 'Line Height', 'convertpro' ),
						'default_value'  => 1.5,
						'min'            => 1,
						'max'            => 50,
						'step'           => 0.1,
						'suffix'         => '',
						'map_style'      => array(
							'parameter' => 'line-height',
							'unit'      => '',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'    => 'label_anim_checkbox',
						'name'  => 'label_anim_checkbox',
						'type'  => 'label',
						'label' => __( 'Animation', 'convertpro' ),
					),
					array(
						'id'            => 'field_animation',
						'name'          => 'field_animation',
						'type'          => 'dropdown',
						'label'         => 'Animation',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_entry_animations', array() ),
						'map'           => array(
							'attr'   => 'data-anim-class',
							'target' => '.cp-field-html-data',
						),
						'map_style'     => array(
							'parameter' => 'removeAnimClass',
							'target'    => '.cp-field-html-data',
							'unit'      => 'data-anim-class',
						),
					),
					array(
						'id'            => 'field_animation_delay',
						'name'          => 'field_animation_delay',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Delay',
						'default_value' => '0ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-delay',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'field_animation_duration',
						'name'          => 'field_animation_duration',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Duration',
						'default_value' => '1000ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-duration',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'             => 'label_layout_checkbox',
						'name'           => 'label_layout_checkbox',
						'type'           => 'label',
						'label'          => __( 'Size', 'convertpro' ),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 105,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 85,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'checkbox_size',
						'name'           => 'checkbox_size',
						'type'           => 'number',
						'label'          => __( 'Checkbox Size', 'convertpro' ),
						'default_value'  => 16,
						'min'            => 16,
						'max'            => 100,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'checkbox-size',
							'target'    => '.cp-target .cp-checkbox-wrap input[type=checkbox]',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_checkbox_options = apply_filters( 'cp_form_checkbox_options', $cp_form_checkbox_options );

	$cp_form_hiddeninput_options = array(
		'type'         => 'cp_hidden_input',
		'class'        => '',
		'name'         => 'cp_hidden_input',
		'opts'         => array(
			'title'          => __( 'Hidden Input', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,form fields,hidden',
			'resize'         => true,
			'show_on_mobile' => false,
			'global'         => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Hidden Input',
				'params' => array(
					array(
						'id'            => 'hidden_input_name',
						'name'          => 'hidden_input_name',
						'type'          => 'text',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => 'hiddenfield1',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
						'map_style'     => array(
							'parameter' => 'hidden-input-name',
						),
					),
					array(
						'id'            => 'hidden_input_value',
						'name'          => 'hidden_input_value',
						'type'          => 'text',
						'label'         => __( 'Hidden Field Value', 'convertpro' ),
						'default_value' => '',
						'suffix'        => '',
						'map_style'     => array(
							'parameter' => 'hidden-input',
						),
						'map'           => array(
							'attr'   => 'value',
							'target' => '.cp-target',
						),
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_hiddeninput_options = apply_filters( 'cp_form_hiddeninput_options', $cp_form_hiddeninput_options );

	$cp_form_google_recaptcha_options = array(
		'type'         => 'cp_google_recaptcha',
		'class'        => '',
		'name'         => 'cp_google_recaptcha',
		'opts'         => array(
			'title'          => __( 'Recaptcha Info', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,email,form fields,hidden',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Recaptcha Info',
				'params' => array(
					array(
						'id'            => 'recaptcha_input_name',
						'name'          => 'recaptcha_input_name',
						'type'          => 'text',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => 'recaptcha field',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
						'map_style'     => array(
							'parameter' => 'hidden-input-name',
						),
					),
					array(
						'id'            => 'recaptcha_input_value',
						'name'          => 'recaptcha_input_value',
						'type'          => 'hidden',
						'label'         => __( 'Recaptcha Site key', 'convertpro' ),
						'default_value' => get_option( 'cp_google_recaptcha_site_key' ),
						'suffix'        => '',
						'map_style'     => array(
							'parameter' => 'recaptcha-input',
						),
						'map'           => array(
							'attr'   => 'value',
							'target' => '.cp-target',
						),
					),
					array(
						'id'    => 'recaptcha_setting_link',
						'name'  => 'recaptcha_setting_link',
						'type'  => 'label',
						'label' => /* translators:%s module name .*/
						sprintf( __( '%s ', 'convertpro' ), $recaptcha_setting_link ), // PHPCS:ignore WordPress.WP.I18n.NoEmptyStrings
						'map'   => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
				),
			),
		),

		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_google_recaptcha_options = apply_filters( 'cp_form_google_recaptcha_options', $cp_form_google_recaptcha_options );

	$cp_form_date_options = array(
		'type'         => 'cp_date',
		'class'        => '',
		'name'         => 'cp_date',
		'opts'         => array(
			'title'          => __( 'Date', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'input,date,form fields',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'            => 'date_name',
						'name'          => 'date_name',
						'type'          => 'text',
						'label'         => __( 'Name', 'convertpro' ),
						'default_value' => 'datefield',
						'suffix'        => '',
						'map'           => array(
							'attr'   => 'name',
							'target' => '.cp-target',
						),
						'map_style'     => array(
							'parameter' => 'date-data-placeholder',
						),
					),
					array(
						'id'            => 'date_placeholder',
						'name'          => 'date_placeholder',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Placeholder', 'convertpro' ),
						'default_value' => __( 'MM/DD/YYYY', 'convertpro' ),
						'map'           => array(
							'attr'   => 'placeholder',
							'target' => '.cp-target',
						),
					),
					array(
						'id'            => 'date_field_format',
						'name'          => 'date_field_format',
						'type'          => 'dropdown',
						'label'         => 'Date Format',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_date_format', array() ),
						'map'           => array(
							'attr'   => 'data-cp-date-format',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'required',
						'name'          => 'required',
						'type'          => 'switch',
						'label'         => __( 'Required', 'convertpro' ),
						'suffix'        => '',
						'default_value' => false,
						'options'       => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'required',
							'target' => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'    => 'label_anim_date',
						'name'  => 'label_anim_date',
						'type'  => 'label',
						'label' => __( 'Animation', 'convertpro' ),
					),
					array(
						'id'            => 'field_animation',
						'name'          => 'field_animation',
						'type'          => 'dropdown',
						'label'         => 'Animation',
						'default_value' => 'none',
						'options'       => apply_filters( 'cp_entry_animations', array() ),
						'map'           => array(
							'attr'   => 'data-anim-class',
							'target' => '.cp-field-html-data',
						),
						'map_style'     => array(
							'parameter' => 'removeAnimClass',
							'target'    => '.cp-field-html-data',
							'unit'      => 'data-anim-class',
						),
					),
					array(
						'id'            => 'field_animation_delay',
						'name'          => 'field_animation_delay',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Delay',
						'default_value' => '0ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-delay',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'            => 'field_animation_duration',
						'name'          => 'field_animation_duration',
						'type'          => 'number',
						'suffix'        => 'ms,s',
						'label'         => 'Animation Duration',
						'default_value' => '1000ms',
						'min'           => 0,
						'dependency'    => array(
							'name'     => 'field_animation',
							'operator' => '!=',
							'value'    => 'cp-none',
						),
						'map'           => array(
							'attr'   => 'data-anim-duration',
							'target' => '.cp-field-html-data',
						),
					),
					array(
						'id'             => 'label_layout_date',
						'name'           => 'label_layout_date',
						'type'           => 'label',
						'label'          => __( 'Size', 'convertpro' ),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 230,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 45,
						'min'            => 1,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'date_field_type',
						'name'           => 'date_field_type',
						'type'           => 'hidden',
						'label'          => 'Date Field Type',
						'default_value'  => 'yes',
						'hide_on_mobile' => true,
						'map'            => array(
							'attr'   => 'date-field-type',
							'target' => '.cp-target',
						),
					),
				),
			),
		),
		'panel'        => 'Form',
		'section'      => 'Design',
		'has_params'   => true,
		'category'     => 'Form Fields',
		'section_icon' => 'cp-icon-field',
	);

	$cp_form_date_options = apply_filters( 'cp_form_date_options', $cp_form_date_options );

	$cp_button_flatbtn_options = array(
		'type'         => 'cp_button',
		'class'        => '',
		'name'         => 'cp_button',
		'opts'         => array(
			'title'          => __( 'Button', 'convertpro' ),
			'value'          => 'Sample Button',
			'description'    => '',
			'tags'           => 'button,flat button,round button,border button',
			'resize'         => true,
			'show_on_mobile' => false,
			'presets'        => apply_filters( 'cp_button_presets', array() ),
		),
		'sections'     => array(
			array(
				'title'  => 'Text',
				'params' => array(
					array(
						'id'            => 'title',
						'name'          => 'title',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Button Text', 'convertpro' ),
						'default_value' => __( 'Subscribe', 'convertpro' ),
						'map_style'     => array(
							'parameter' => 'inner-html',
							'attr'      => 'value',
							'target'    => '.cp-target',
						),
					),
				),
			),
			array(
				'title'  => 'Colors',
				'params' => array(
					array(
						'id'            => 'button_text_color',
						'name'          => 'button_text_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Text Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'color',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'            => 'button_text_hover_color',
						'name'          => 'button_text_hover_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Text Hover Color', 'convertpro' ),
						'default_value' => '',
						'map_style'     => array(
							'parameter' => 'color',
							'onhover'   => true,
						),
					),
					array(
						'id'            => 'button_back_color',
						'name'          => 'button_back_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Background Color', 'convertpro' ),
						'default_value' => '#337ab7',
						'map_style'     => array(
							'parameter' => 'background',
						),
					),
					array(
						'id'            => 'button_back_color_hover',
						'name'          => 'button_back_color_hover',
						'type'          => 'colorpicker',
						'label'         => __( 'Background Hover Color', 'convertpro' ),
						'default_value' => '',
						'map_style'     => array(
							'parameter' => 'background',
							'onhover'   => true,
						),
					),
				),
			),
			array(
				'title'  => 'Action',
				'params' => array(
					array(
						'id'            => 'field_action',
						'name'          => 'field_action',
						'type'          => 'dropdown',
						'label'         => 'Field Action',
						'default_value' => 'submit',
						'options'       => array(
							'none'               => __( 'None', 'convertpro' ),
							'submit'             => __( 'Submit', 'convertpro' ),
							'submit_n_goto_step' => __( 'Submit & Go to Step', 'convertpro' ),
							'submit_n_goto_url'  => __( 'Submit & Go to URL', 'convertpro' ),
							'submit_n_close'     => __( 'Submit & Close', 'convertpro' ),
							'goto_url'           => __( 'Go to URL', 'convertpro' ),
							'goto_step'          => __( 'Go to Step', 'convertpro' ),
							'close'              => __( 'Close', 'convertpro' ),
							'close_tab'          => __( 'Close Page', 'convertpro' ),
							'close_n_goto_url'   => __( 'Close & Go to URL', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'button-type',
							'target' => '.cp-target',
						),
					),
				),
			),
		),
		'panel'        => 'Button',
		'section'      => 'Design',
		'section_icon' => 'cp-icon-btn',
	);

	$cp_button_flatbtn_options = apply_filters( 'cp_button_flatbtn_options', $cp_button_flatbtn_options );

	$cp_button_gradientbtn_options = array(
		'type'         => 'cp_gradient_button',
		'class'        => '',
		'name'         => 'cp_gradient_button',
		'opts'         => array(
			'title'          => __( 'Gradient Button', 'convertpro' ),
			'value'          => 'Sample Button',
			'description'    => '',
			'tags'           => 'button,gradient button',
			'resize'         => true,
			'presets'        => apply_filters( 'cp_gradient_button_presets', array() ),
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'Text',
				'params' => array(
					array(
						'id'            => 'title',
						'name'          => 'title',
						'type'          => 'text',
						'suffix'        => '',
						'label'         => __( 'Button Text', 'convertpro' ),
						'default_value' => __( 'Subscribe', 'convertpro' ),
						'map_style'     => array(
							'parameter' => 'inner-html',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'            => 'btn_font_family',
						'name'          => 'btn_font_family',
						'type'          => 'font',
						'label'         => 'Font Family',
						'default_value' => 'inherit',
						'map_style'     => array(
							'parameter' => 'font-family',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'             => 'btn_title_size',
						'name'           => 'btn_title_size',
						'type'           => 'number',
						'suffix'         => 'px',
						'label'          => __( 'Font Size', 'convertpro' ),
						'default_value'  => '14px',
						'map_style'      => array(
							'parameter' => 'font-size',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'btn_grad_letter_spacing',
						'name'           => 'btn_grad_letter_spacing',
						'type'           => 'number',
						'suffix'         => 'px,em',
						'label'          => __( 'Letter Spacing', 'convertpro' ),
						'default_value'  => '0',
						'map_style'      => array(
							'parameter' => 'letter-spacing',
							'target'    => '.cp-target',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'btn_grad_text_align',
						'name'           => 'btn_grad_text_align',
						'type'           => 'text_align',
						'label'          => __( 'Text Alignment', 'convertpro' ),
						'options'        => array(
							'center'  => __( 'center', 'convertpro' ),
							'left'    => __( 'left', 'convertpro' ),
							'right'   => __( 'right', 'convertpro' ),
							'justify' => __( 'justify', 'convertpro' ),
						),
						'default_value'  => 'center',
						'map_style'      => array(
							'parameter' => 'text-align',
							'target'    => '.cp-target',
						),
						'show_on_mobile' => true,
					),
				),
			),
			array(
				'title'  => 'Colors',
				'params' => array(
					array(
						'id'            => 'btn_title_color',
						'name'          => 'btn_title_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Text Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'color',
							'target'    => '.cp-target',
						),
					),
					array(
						'id'            => 'btn_title_color_hover',
						'name'          => 'btn_title_color_hover',
						'type'          => 'colorpicker',
						'label'         => __( 'Text Hover Color', 'convertpro' ),
						'default_value' => '#23282d',
						'map_style'     => array(
							'target'    => '.cp-target',
							'parameter' => 'color',
							'onhover'   => true,
						),
					),
					array(
						'id'            => 'btn_back_color',
						'name'          => 'btn_back_color',
						'type'          => 'colorpicker',
						'label'         => __( 'First Background Color', 'convertpro' ),
						'default_value' => '#b3b3b3',
						'map_style'     => array(
							'parameter' => 'btn-gradient-bg1',
						),
					),
					array(
						'id'            => 'sec_btn_back_color',
						'name'          => 'sec_btn_back_color',
						'type'          => 'colorpicker',
						'label'         => __( 'Second Background Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'btn-gradient-bg2',
						),
					),
					array(
						'id'            => 'btn_gradient_loc_1',
						'name'          => 'btn_gradient_loc_1',
						'type'          => 'slider',
						'label'         => __( 'Gradient Start Location', 'convertpro' ),
						'default_value' => 0,
						'min'           => 0,
						'max'           => 100,
						'step'          => 1,
						'suffix'        => '%',
						'map_style'     => array(
							'parameter' => 'btn-gradient-loc-1',
						),
					),
					array(
						'id'            => 'btn_gradient_loc_2',
						'name'          => 'btn_gradient_loc_2',
						'type'          => 'slider',
						'label'         => __( 'Gradient End Location', 'convertpro' ),
						'default_value' => 100,
						'min'           => 0,
						'max'           => 100,
						'step'          => 1,
						'suffix'        => '%',
						'map_style'     => array(
							'parameter' => 'btn-gradient-loc-2',
						),
					),
					array(
						'id'            => 'btn_gradient_types',
						'name'          => 'btn_gradient_types',
						'type'          => 'dropdown',
						'label'         => __( 'Type', 'convertpro' ),
						'default_value' => 'lineargradient',
						'options'       => array(
							'lineargradient' => __( 'Linear', 'convertpro' ),
							'radialgradient' => __( 'Radial', 'convertpro' ),
						),
						'map_style'     => array(
							'parameter' => 'btn-gradient-type',
						),
					),
					array(
						'id'            => 'btn_gradient_radial_dir',
						'name'          => 'btn_gradient_radial_dir',
						'type'          => 'dropdown',
						'label'         => __( 'Gradient Direction', 'convertpro' ),
						'default_value' => 'center_center',
						'options'       => array(
							'center_center' => __( 'Center Center', 'convertpro' ),
							'center_left'   => __( 'Center Left', 'convertpro' ),
							'center_right'  => __( 'Center Right', 'convertpro' ),
							'top_center'    => __( 'Top Center', 'convertpro' ),
							'top_left'      => __( 'Top Left', 'convertpro' ),
							'top_right'     => __( 'Top Right', 'convertpro' ),
							'bottom_center' => __( 'Bottom Center', 'convertpro' ),
							'bottom_left'   => __( 'Bottom Left', 'convertpro' ),
							'bottom_right'  => __( 'Bottom Right', 'convertpro' ),
						),
						'map_style'     => array(
							'parameter' => 'btn-gradient-radial-dir',
						),
						'dependency'    => array(
							'name'     => 'btn_gradient_types',
							'operator' => '==',
							'value'    => 'radialgradient',
						),
					),
					array(
						'id'            => 'btn_gradient_linear_angle',
						'name'          => 'btn_gradient_linear_angle',
						'type'          => 'slider',
						'label'         => __( 'Gradient Direction', 'convertpro' ),
						'default_value' => 180,
						'min'           => 1,
						'max'           => 360,
						'step'          => 1,
						'suffix'        => 'deg',
						'map_style'     => array(
							'parameter' => 'btn-gradient-angle',
						),
						'dependency'    => array(
							'name'     => 'btn_gradient_types',
							'operator' => '==',
							'value'    => 'lineargradient',
						),
					),
					array(
						'id'             => 'btn_gradient_hover_options',
						'name'           => 'btn_gradient_hover_options',
						'type'           => 'switch',
						'default_value'  => false,
						'label'          => __( 'On Hover Color', 'convertpro' ),
						'hide_on_mobile' => true,
						'options'        => array(
							'on'  => __( 'Custom', 'convertpro' ),
							'off' => __( 'Inherit', 'convertpro' ),
						),
						'map_style'      => array(
							'parameter' => 'btn-gradient-hover-options',
						),
					),
					array(
						'id'            => 'btn_back_color_hover',
						'name'          => 'btn_back_color_hover',
						'type'          => 'colorpicker',
						'label'         => __( 'First Hover Background Color', 'convertpro' ),
						'default_value' => '#b3b3b3',
						'map_style'     => array(
							'parameter' => 'btn-gradient-bg1-hover',
						),
						'dependency'    => array(
							'name'     => 'btn_gradient_hover_options',
							'operator' => '==',
							'value'    => 'true',
						),
					),
					array(
						'id'            => 'sec_btn_back_color_hover',
						'name'          => 'sec_btn_back_color_hover',
						'type'          => 'colorpicker',
						'label'         => __( 'Second Hover Background Color', 'convertpro' ),
						'default_value' => '#555',
						'map_style'     => array(
							'parameter' => 'btn-gradient-bg2-hover',
						),
						'dependency'    => array(
							'name'     => 'btn_gradient_hover_options',
							'operator' => '==',
							'value'    => 'true',
						),
					),
					array(
						'id'            => 'btn_gradient_loc_1_hover',
						'name'          => 'btn_gradient_loc_1_hover',
						'type'          => 'slider',
						'label'         => __( 'Hover Start Location', 'convertpro' ),
						'default_value' => 0,
						'min'           => 0,
						'max'           => 100,
						'step'          => 1,
						'suffix'        => '%',
						'map_style'     => array(
							'parameter' => 'btn-gradient-loc-1-hover',
						),
						'dependency'    => array(
							'name'     => 'btn_gradient_hover_options',
							'operator' => '==',
							'value'    => 'true',
						),
					),
					array(
						'id'            => 'btn_gradient_loc_2_hover',
						'name'          => 'btn_gradient_loc_2_hover',
						'type'          => 'slider',
						'label'         => __( 'Hover End Location', 'convertpro' ),
						'default_value' => 100,
						'min'           => 0,
						'max'           => 100,
						'step'          => 1,
						'suffix'        => '%',
						'map_style'     => array(
							'parameter' => 'btn-gradient-loc-2-hover',
						),
						'dependency'    => array(
							'name'     => 'btn_gradient_hover_options',
							'operator' => '==',
							'value'    => 'true',
						),
					),
					array(
						'id'            => 'btn_gradient_types_hover',
						'name'          => 'btn_gradient_types_hover',
						'type'          => 'dropdown',
						'label'         => __( 'Type', 'convertpro' ),
						'default_value' => 'lineargradient',
						'options'       => array(
							'lineargradient' => __( 'Linear', 'convertpro' ),
							'radialgradient' => __( 'Radial', 'convertpro' ),
						),
						'map_style'     => array(
							'parameter' => 'btn-gradient-type-hover',
						),
						'dependency'    => array(
							'name'     => 'btn_gradient_hover_options',
							'operator' => '==',
							'value'    => 'true',
						),
					),
					array(
						'id'            => 'btn_gradient_radial_dir_hover',
						'name'          => 'btn_gradient_radial_dir_hover',
						'type'          => 'dropdown',
						'label'         => __( 'Hover Gradient Direction', 'convertpro' ),
						'default_value' => 'center_center',
						'options'       => array(
							'center_center' => __( 'Center Center', 'convertpro' ),
							'center_left'   => __( 'Center Left', 'convertpro' ),
							'center_right'  => __( 'Center Right', 'convertpro' ),
							'top_center'    => __( 'Top Center', 'convertpro' ),
							'top_left'      => __( 'Top Left', 'convertpro' ),
							'top_right'     => __( 'Top Right', 'convertpro' ),
							'bottom_center' => __( 'Bottom Center', 'convertpro' ),
							'bottom_left'   => __( 'Bottom Left', 'convertpro' ),
							'bottom_right'  => __( 'Bottom Right', 'convertpro' ),
						),
						'map_style'     => array(
							'parameter' => 'btn-gradient-radial-dir-hover',
						),
						'dependency'    => array(
							'relation' => 'AND',
							array(
								'name'     => 'btn_gradient_hover_options',
								'operator' => '==',
								'value'    => 'true',
							),
							array(
								'name'     => 'btn_gradient_types_hover',
								'operator' => '==',
								'value'    => 'radialgradient',
							),
						),
					),
					array(
						'id'            => 'btn_gradient_linear_angle_hover',
						'name'          => 'btn_gradient_linear_angle_hover',
						'type'          => 'slider',
						'label'         => __( 'Hover Gradient Direction', 'convertpro' ),
						'default_value' => 180,
						'min'           => 0,
						'max'           => 360,
						'step'          => 1,
						'suffix'        => 'deg',
						'map_style'     => array(
							'parameter' => 'btn-gradient-angle-hover',
						),
						'dependency'    => array(
							'relation' => 'AND',
							array(
								'name'     => 'btn_gradient_hover_options',
								'operator' => '==',
								'value'    => 'true',
							),
							array(
								'name'     => 'btn_gradient_types_hover',
								'operator' => '==',
								'value'    => 'lineargradient',
							),
						),
					),
				),
			),
			array(
				'title'  => 'Action',
				'params' => array(
					array(
						'id'            => 'field_action',
						'name'          => 'field_action',
						'type'          => 'dropdown',
						'label'         => 'Field Action',
						'default_value' => 'submit',
						'options'       => array(
							'none'               => __( 'None', 'convertpro' ),
							'submit'             => __( 'Submit', 'convertpro' ),
							'submit_n_goto_step' => __( 'Submit & Go to Step', 'convertpro' ),
							'submit_n_goto_url'  => __( 'Submit & Go to URL', 'convertpro' ),
							'submit_n_close'     => __( 'Submit & Close', 'convertpro' ),
							'goto_url'           => __( 'Go To URL', 'convertpro' ),
							'goto_step'          => __( 'Go To Step', 'convertpro' ),
							'close'              => __( 'Close', 'convertpro' ),
							'close_tab'          => __( 'Close Page', 'convertpro' ),
							'close_n_goto_url'   => __( 'Close & Go to URL', 'convertpro' ),
						),
						'map'           => array(
							'attr'   => 'button-type',
							'target' => '.cp-target',
						),
					),
				),
			),
		),
		'panel'        => 'Button',
		'section'      => 'Design',
		'section_icon' => 'cp-icon-btn',
	);

	$video_options = array(
		'type'         => 'cp_video',
		'class'        => '',
		'name'         => 'cp_video',
		'opts'         => array(
			'title'          => __( 'Video', 'convertpro' ),
			'value'          => '',
			'description'    => '',
			'tags'           => 'video',
			'resize'         => true,
			'show_on_mobile' => false,
		),
		'sections'     => array(
			array(
				'title'  => 'General',
				'params' => array(
					array(
						'id'             => 'video_source',
						'name'           => 'video_source',
						'label'          => __( 'Source', 'convertpro' ),
						'type'           => 'dropdown',
						'default_value'  => 'youtube',
						'options'        => array(
							'youtube'    => __( 'YouTube', 'convertpro' ),
							'vimeo'      => __( 'Vimeo', 'convertpro' ),
							'custom_url' => __( 'Custom URL', 'convertpro' ),
						),
						'map_style'      => array(
							'parameter' => 'video_source',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'video_id',
						'name'           => 'video_id',
						'type'           => 'text',
						'label'          => __( 'Video ID', 'convertpro' ),
						'default_value'  => 'y1kV8iW8aDk',
						'map_style'      => array(
							'parameter' => 'video_id',
						),
						'dependency'     => array(
							'relation' => 'OR',
							array(
								'name'     => 'video_source',
								'operator' => '==',
								'value'    => 'youtube',
							),
							array(
								'name'     => 'video_source',
								'operator' => '==',
								'value'    => 'vimeo',
							),
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'video_url',
						'name'           => 'video_url',
						'type'           => 'text',
						'label'          => __( 'Video URL', 'convertpro' ),
						'default_value'  => '',
						'map_style'      => array(
							'parameter' => 'video_url',
						),
						'dependency'     => array(
							'name'     => 'video_source',
							'operator' => '==',
							'value'    => 'custom_url',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'video_autoplay',
						'name'           => 'video_autoplay',
						'type'           => 'switch',
						'suffix'         => '',
						'default_value'  => false,
						'options'        => array(
							'on'  => __( 'YES', 'convertpro' ),
							'off' => __( 'NO', 'convertpro' ),
						),
						'label'          => __( 'Autoplay', 'convertpro' ),
						'map'            => array(
							'attr'   => 'video_autoplay',
							'target' => '.cp-target',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'video_controls',
						'name'           => 'video_controls',
						'type'           => 'switch',
						'suffix'         => '',
						'default_value'  => true,
						'options'        => array(
							'on'  => __( 'SHOW', 'convertpro' ),
							'off' => __( 'HIDE', 'convertpro' ),
						),
						'dependency'     => array(
							'name'     => 'video_source',
							'operator' => '==',
							'value'    => 'youtube',
						),
						'label'          => __( 'Player Controls', 'convertpro' ),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'video_start_at',
						'name'           => 'video_start_at',
						'type'           => 'number',
						'suffix'         => 'sec',
						'label'          => __( 'Start Time', 'convertpro' ),
						'min'            => 0,
						'max'            => 10000,
						'step'           => 1,
						'dependency'     => array(
							'name'     => 'video_source',
							'operator' => '==',
							'value'    => 'youtube',
						),
						'default_value'  => '0sec',
						'show_on_mobile' => true,
					),
				),
			),
			array(
				'title'  => 'Advanced',
				'params' => array(
					array(
						'id'             => 'width',
						'name'           => 'width',
						'label'          => __( 'Width', 'convertpro' ),
						'type'           => 'number',
						'default_value'  => 500,
						'min'            => 0,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'width',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
					array(
						'id'             => 'height',
						'name'           => 'height',
						'type'           => 'number',
						'label'          => __( 'Height', 'convertpro' ),
						'default_value'  => 281,
						'min'            => 0,
						'max'            => 800,
						'step'           => 1,
						'suffix'         => 'px',
						'map_style'      => array(
							'parameter' => 'height',
							'unit'      => 'px',
						),
						'show_on_mobile' => true,
					),
				),
			),
		),
		'panel'        => 'Elements',
		'section'      => 'Design',
		'section_icon' => 'dashicons dashicons-screenoptions',
	);

	$video_options = apply_filters( 'cp_video_options', $video_options );

	$cp_button_gradientbtn_options = apply_filters( 'cp_button_gradientbtn_options', $cp_button_gradientbtn_options );

	// Set default for Element Panel.
	cp_Framework::$close_link_opts     = $close_link_options;
	cp_Framework::$close_image_opts    = $close_image_options;
	cp_Framework::$cp_shapes_opts      = $cp_shapes_options;
	cp_Framework::$cp_image_opts       = $cp_image_options;
	cp_Framework::$cp_custom_html_opts = $cp_custom_html_options;
	cp_Framework::$cp_paragraph_opts   = $cp_paragraph_options;
	cp_Framework::$cp_subheading_opts  = $cp_subheading_options;
	cp_Framework::$cp_heading_opts     = $cp_heading_options;
	cp_Framework::$cp_countdown_opts   = $cp_countdown_options;

	// Set default for Form Panel.
	cp_Framework::$cp_form_email_opts            = $cp_form_email_options;
	cp_Framework::$cp_form_name_opts             = $cp_form_name_options;
	cp_Framework::$cp_form_phone_opts            = $cp_form_phone_options;
	cp_Framework::$cp_form_dropdown_opts         = $cp_form_dropdown_options;
	cp_Framework::$cp_form_textarea_opts         = $cp_form_textarea_options;
	cp_Framework::$cp_form_radio_opts            = $cp_form_radio_options;
	cp_Framework::$cp_form_checkbox_opts         = $cp_form_checkbox_options;
	cp_Framework::$cp_form_hiddeninput_opts      = $cp_form_hiddeninput_options;
	cp_Framework::$cp_form_google_recaptcha_opts = $cp_form_google_recaptcha_options;
	cp_Framework::$cp_form_date_opts             = $cp_form_date_options;
	cp_Framework::$cp_button_flatbtn_opts        = $cp_button_flatbtn_options;
	cp_Framework::$cp_button_gradientbtn_opts    = $cp_button_gradientbtn_options;
	cp_Framework::$cp_video_options              = $video_options;
