<?php
namespace WPCS\Migration\API;

use WPCS\Migration\Helpers;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) )
    exit;

class JobService
{
    private $job_id;

    public function __construct($job_id)
    {
        $this->job_id = $job_id;
    }

    public function set_status($status)
    {
        $this->write_job_data([
            'job_id' => $this->job_id,
            'last_status' => $status,
        ]);
    }

    public function set_progress($total, $progress)
    {
        $this->write_job_data([
            'progress' => [
                'total' => $total,
                'progress' => $progress,
            ],
        ]);
    }

    public function get_status()
    {
        $status_path = $this->get_status_file_path();
        if(file_exists($status_path))
        {
            $data = file_get_contents($status_path);
            return json_decode($data);
        }
        
        return [
            'status' => false
        ];
    }

    public function cleanup()
    {
        unlink($this->get_status_file_path());
    }

    private function get_status_file_path()
    {
        $job_id = $this->job_id;
        return Helpers::join_paths($this->get_job_status_dir(), "$job_id.json");
    }

    private function get_job_status_dir()
    {
        $wpcs_dir = Helpers::get_wpcs_dir(true);
        $dir = Helpers::join_paths($wpcs_dir, 'jobs');

        if(!is_dir($dir))
        {
            mkdir($dir);
        }

        return $dir;
    }

    private function write_job_data($data)
    {
        $status_path = $this->get_status_file_path();

        $writable_data = $data;

        if(file_exists($status_path))
        {
            $current_contents = file_get_contents($status_path);
            
            if(!empty($current_contents))
            {
                $current_data = json_decode($current_contents);
                $writable_data = array_merge((array) $current_data, $data);
            }
        }

        file_put_contents($status_path, json_encode($writable_data));
    }
}
