(function($) {
    $(document).ready(function() {
        $('#wpcs-auth-save-button').on('click', () => {
            WPCS.setButtonEnabled('#wpcs-auth-save-button', false);

            $('#auth-success-box')
                .addClass('hidden');

            $('#auth-error-box')
                .empty()
                .addClass('hidden');

            $('#home-tab').addClass('disabled');

            WPCS.API.post('/wp-json/wpcs/migration/v1/config/auth', {
                region: $('#wpcs-auth-form-region-input').val(),
                key: $('#wpcs-auth-form-key-input').val(),
                secret: $('#wpcs-auth-form-secret-input').val()
            })
                .done(() => {
                    checkCredentials();
                })
                .always(() => {
                    WPCS.setButtonEnabled('#wpcs-auth-save-button', true);
                });
        });

        $('#wpcs-auth-check-button').on('click', () => {
            WPCS.setButtonEnabled('#wpcs-auth-check-button', false);

            $('#auth-success-box')
                .addClass('hidden');

            $('#auth-error-box')
                .empty()
                .addClass('hidden');

            $('#home-tab').addClass('disabled');

            checkCredentials();
        });
    });

    function checkCredentials()
    {
        WPCS.API.get('/wp-json/wpcs/migration/v1/config/auth/check')
            .done(() => {
                $('#auth-success-box').removeClass('hidden');
                $('#home-tab').removeClass('disabled');
            })
            .fail(() => {
                $('#home-tab').addClass('disabled')
                $('#auth-error-box')
                    .empty()
                    .text('Credentials not valid. Please check if you have entered the credentials correctly, or recycle your current credentials and enter the new ones.')
                    .removeClass('hidden');
            })
            .always(() => {
                WPCS.setButtonEnabled('#wpcs-auth-check-button', true);
            });
    }
})( jQuery );
