(function($) {
    const modalPrefix = 'tenant-create-modal';

    $(document).ready(function() {
        $(`#${modalPrefix}-submit-button`).on('click', () => {
            $(`#${modalPrefix}`)
                .find('input, textarea, button, select')
                .attr('disabled','disabled');

            resetModal();

            WPCS.setButtonEnabled(`#${modalPrefix}-submit-button`, false);
            const jobId = (Math.random() + 1).toString(36).substring(7);

            WPCS.API.post('/wp-json/wpcs/migration/v1/migrate/tenant', {
                name: $(`#${modalPrefix}-name-input`).val(),
                externalId: $(`#${modalPrefix}-external-id-input`).val(),
                versionId: $(`#${modalPrefix}-version-select`).val(),
                jobId: jobId,
            })
                .done(() => {
                    setInfo('Succesfully migrated Tenant!');
                })
                .fail((xhr) => {
                    const response = JSON.parse(xhr.responseText);
                    setError(`Request failed with code: ${xhr.status}.<br />Message: "${response.message}"`);
                })
                .always(() => {
                    WPCS.setButtonEnabled(`#${modalPrefix}-submit-button`, true);

                    jobStatusPoller.stop(jobId, $(`#${modalPrefix}-status-box`));

                    $(`#${modalPrefix}`)
                        .find('input, textarea, button, select')
                        .prop('disabled', false);
                });

            jobStatusPoller.start(jobId, $(`#${modalPrefix}-status-box`));
        });

        $(`#${modalPrefix}`).on('show.bs.modal', () => {
            resetModal();
            setSubmitDisabled(true);
        });

        $(`#${modalPrefix}`).on('shown.bs.modal', () => {
            WPCS.API.get('/wp-json/wpcs/migration/v1/versions')
                .done((response) => {
                    const versionSelect = $(`#${modalPrefix}-version-select`);
                    versionSelect.empty();

                    if(response.length < 1) {
                        setSubmitDisabled(true);
                        setError('No Versions found or the only Version is still busy. Please export this site as a Version first or wait until the Version is ready.');

                        versionSelect.append($('<option>', {
                            value: 0,
                            text: 'No Versions found',
                        }))
                    } else {
                        setSubmitDisabled(false);
                        response.forEach(version => {
                            versionSelect.append($('<option>', {
                                value: version.id,
                                text: `${version.name} ${version.isProduction ? '(production)' : ''}`.trimEnd(),
                                selected: version.isProduction,
                            }))
                        })
                        versionSelect.removeClass('disabled')
                    }
                })
                .fail(() => {
                   setError('Something went wrong. Could not fetch Versions.');
                });
        })
    });

    function resetModal(){
        $(`#${modalPrefix}-error-box`)
            .empty()
            .addClass('hidden');

        $(`#${modalPrefix}-info-box`)
            .empty()
            .addClass('hidden');

        $(`#${modalPrefix}-status-box`).empty();
    }

    function setError(error){
        $(`#${modalPrefix}-error-box`)
            .empty()
            .append(error)
            .removeClass('hidden');
    }

    function setInfo(info){
        $(`#${modalPrefix}-info-box`)
            .empty()
            .append(info)
            .removeClass('hidden');
    }

    function setSubmitDisabled(disabled = true)
    {
        $(`#${modalPrefix}-submit-button`)
            .attr('disabled', disabled ? 'disabled' : false);
    }

})( jQuery );
