(function($) {
    function fillVersionSelect(select, versionData){
        select.empty();

        versionData.versions.forEach(version => {
            select.append($('<option>', {
                value: version,
                text: version,
                selected: version === versionData.recommended,
            }))
        })
        select.removeClass('disabled');
    }

    const modalPrefix = 'version-create-modal';

    $(document).ready(function() {
        $(`#${modalPrefix}-submit-button`).on('click', () => {
            $(`#${modalPrefix}`)
                .find('input, textarea, button, select')
                .attr('disabled','disabled');

            resetModal();

            WPCS.setButtonEnabled(`#${modalPrefix}-submit-button`, false);
            const jobId = (Math.random() + 1).toString(36).substring(7);

            WPCS.API.post('/wp-json/wpcs/migration/v1/migrate/version', {
                name: $(`#${modalPrefix}-name-input`).val(),
                phpVersion: $(`#${modalPrefix}-php-version-select`).val(),
                wordpressVersion: $(`#${modalPrefix}-wordpress-version-select`).val(),
                skipUploads: $(`#${modalPrefix}-skip-uploads-checkbox`).is(":checked"),
                jobId: jobId,
            })
                .done(() => {
                    setInfo('Succesfully migrated Version!');
                })
                .fail((xhr) => {
                    const response = JSON.parse(xhr.responseText);
                    setError(`Request failed with code: ${xhr.status}.<br />Message: "${response.message}"`);
                })
                .always(() => {
                    WPCS.setButtonEnabled(`#${modalPrefix}-submit-button`, true);

                    jobStatusPoller.stop(jobId, $(`#${modalPrefix}-status-box`));

                    $(`#${modalPrefix}`)
                        .find('input, textarea, button, select')
                        .prop('disabled', false);
                });

            jobStatusPoller.start(jobId, $(`#${modalPrefix}-status-box`));
        });

        $(`#${modalPrefix}`).on('show.bs.modal', () => {
            resetModal();
        });

        $(`#${modalPrefix}`).on('shown.bs.modal', () => {
            WPCS.API.get('/wp-json/wpcs/migration/v1/info/versions')
                .done((response) => {
                    fillVersionSelect(
                        $(`#${modalPrefix}-wordpress-version-select`),
                        response.wp,
                    );

                    fillVersionSelect(
                        $(`#${modalPrefix}-php-version-select`),
                        response.php,
                    );
                })
                .fail(() => {
                    setError('Something went wrong. Could not fetch info from WPCS.');
                });

            WPCS.API.get('/wp-json/wpcs/migration/v1/info/dir-size')
                .done((response) => {
                    const uploadsSizeBytes = response.uploads.size;
                    const fourGigabytesInBytes = 4294967296;

                    if(uploadsSizeBytes >= fourGigabytesInBytes)
                    {
                        $(`#${modalPrefix}-skip-uploads-checkbox`)
                            .prop('checked', true)
                            .attr('disabled', true);
    
                        $(`#${modalPrefix}-skip-uploads-checkbox-disabled-message`)
                            .text(`The uploads directory is larger than 4Gb (${niceBytes(uploadsSizeBytes)}). Only tenants can be exported with large uploads directories.`);
                        $(`#${modalPrefix}-info-box`)
                            .text(`'Skip uploads' has been enabled because the uploads directory is too large.`)
                            .removeClass('hidden');
                    }
                })
                .fail(() => {
                    setError('Something went wrong. Could not fetch info about your WordPress installation.');
                });
        })
    });
    
    function niceBytes(x){
        const units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
        let l = 0, n = parseInt(x, 10) || 0;
        while(n >= 1024 && ++l){
            n = n/1024;
        }
        return(n.toFixed(n < 10 && l > 0 ? 1 : 0) + ' ' + units[l]);
    }

    function resetModal(){
        $(`#${modalPrefix}-error-box`)
            .empty()
            .addClass('hidden');

        $(`#${modalPrefix}-info-box`)
            .empty()
            .addClass('hidden');

        $(`#${modalPrefix}-status-box`).empty();
    }

    function setError(error){
        $(`#${modalPrefix}-error-box`)
            .empty()
            .append(error)
            .removeClass('hidden');
    }

    function setInfo(info){
        $(`#${modalPrefix}-info-box`)
            .empty()
            .append(info)
            .removeClass('hidden');
    }

})( jQuery );
