const WPCS = {
    setButtonEnabled: (buttonSelector, enabled) => {
        jQuery(buttonSelector).attr('disabled', !enabled);

        if (enabled) {
            jQuery(`${buttonSelector}-progress`).addClass('d-none');
        } else {
            jQuery(`${buttonSelector}-progress`).removeClass('d-none');
        }
    },
    API: {
        get: (url, timeout = 60000) => {
            return jQuery.ajax({
                type: 'GET',
                url: url,
                timeout: timeout,
                headers: {
                    'X-WP-Nonce': wpcs_api.nonce,
                },
            })
        },
        post: (url, data) => {
            return jQuery.ajax({
                type: 'POST',
                url: url,
                data: JSON.stringify(data),
                headers: {
                    'X-WP-Nonce': wpcs_api.nonce,
                },
            })
        },
    }
}

const intervalHandles = {};

const jobStatusPoller = {
    start: (jobId, statusBox) => {
        const poll = () => {
            WPCS.API.get(`/wp-json/wpcs/migration/v1/jobs/${jobId}/status`, 5000)
                .done((response) => {
                    let progressString = '';
                    if (response.hasOwnProperty('progress') && response.progress.total !== 0) {
                        const progress = (response.progress.progress / response.progress.total) * 100;
                        progressString = `(${progress.toFixed(2)}%)`;
                    }

                    if (response.hasOwnProperty('last_status')) {
                        statusBox.empty().text(`${response.last_status} ${progressString}`);
                    } else {
                        statusBox.empty();
                    }
                })
                .always(() => {
                    // Clear the interval handle if the request is completed or fails
                    if (!intervalHandles.hasOwnProperty(jobId)) {
                        statusBox.empty();
                        return;
                    }

                    // Schedule the next request
                    intervalHandles[jobId] = setTimeout(poll, 500);
                });
        };

        // Start the initial request
        intervalHandles[jobId] = setTimeout(poll, 100);
    },
    stop: (jobId, statusBox) => {
        clearTimeout(intervalHandles[jobId]);
        delete intervalHandles[jobId];
        statusBox.empty();
    }
};