<?php
namespace WPCS\Migration\Admin;

use WPCS\Migration\Helpers;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) )
    exit;

class Module
{
    public static function init()
    {
        add_action( 'admin_menu', [__CLASS__, 'admin_menu'] );
        add_action( 'admin_enqueue_scripts', [__CLASS__, 'admin_enqueue'], 10, 1 );

        Notices::init();
        PluginsList::init();
    }

    public static function admin_menu()
    {
        $page_title = __('WPCS Migration', WPCS_MIGRATION_TEXTDOMAIN);
        $menu_title = __('WPCS Migration', WPCS_MIGRATION_TEXTDOMAIN);
        $capability = 'manage_options';
        $menu_slug = WPCS_MIGRATION_SLUG;
        $function = array( __CLASS__, 'admin_page' );
        $position = null;
        
        add_management_page(
            $page_title,
            $menu_title,
            $capability,
            $menu_slug,
            $function,
            $position,
        );
    }

    public static function admin_page()
    {
        self::render_page();
    }

    public static function admin_enqueue($hook_suffix)
    {
        if($hook_suffix !== 'tools_page_' . WPCS_MIGRATION_SLUG)
        {
            return;
        }

        wp_enqueue_script( 'jquery' );

        wp_enqueue_style( 'bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/css/bootstrap.min.css' );
        wp_enqueue_script( 'bootstrap', 'https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/js/bootstrap.bundle.min.js', [ 'jquery' ], false, true );

        $nonce = wp_create_nonce('wp_rest');

        wp_enqueue_script( 'wpcs-helpers', WPCS_MIGRATION_URL . '/src/Admin/Assets/js/helpers.js', [ 'jquery' ], false, true );
        wp_localize_script('wpcs-helpers', 'wpcs_api', [
            'nonce' => $nonce,
        ]);

        wp_enqueue_script( 'wpcs-auth-config', WPCS_MIGRATION_URL . '/src/Admin/Assets/js/auth-config.js', [ 'jquery', 'wpcs-helpers' ], false, true );
        wp_enqueue_script( 'wpcs-snapshot', WPCS_MIGRATION_URL . '/src/Admin/Assets/js/create-snapshot.js', [ 'jquery', 'wpcs-helpers' ], false, true );
        wp_enqueue_script( 'wpcs-create-version', WPCS_MIGRATION_URL . '/src/Admin/Assets/js/create-version.js', [ 'jquery', 'wpcs-helpers' ], false, true );
        wp_enqueue_script( 'wpcs-create-tenant', WPCS_MIGRATION_URL . '/src/Admin/Assets/js/create-tenant.js', [ 'jquery', 'wpcs-helpers' ], false, true );
    }

    public static function render_page()
    {
        global $wp_version;
        $current_php_version = sprintf('%s.%s', PHP_MAJOR_VERSION, PHP_MINOR_VERSION);

        echo Twig::render('main.twig', [
            'main' => [
                'title' => __('WPCS Migration', WPCS_MIGRATION_TEXTDOMAIN),
                'is_multisite' => is_multisite(),
            ],
            'auth' => [
                'title' => __('API Authentication', WPCS_MIGRATION_TEXTDOMAIN),
                'region' => [
                    'constant' => defined('WPCS_API_REGION') ? constant('WPCS_API_REGION') : false,
                    'option' => get_option('WPCS_API_REGION'),
                ],
                'key' => [
                    'constant' => defined('WPCS_API_KEY') ? constant('WPCS_API_KEY') : false,
                    'option' => get_option('WPCS_API_KEY'),
                ],
                'secret' => [
                    'constant' => defined('WPCS_API_SECRET') ? constant('WPCS_API_SECRET') : false,
                    'option' => get_option('WPCS_API_SECRET'),
                ],
            ],
            'migration' => [
                'title' => __('Export', WPCS_MIGRATION_TEXTDOMAIN),
                'general' => [
                    'is_authenticated' => Helpers::is_authenticated(),
                ],
                'create_version_modal' => [
                    'title' => __('Export to WPCS as Version', WPCS_MIGRATION_TEXTDOMAIN),
                    'id' => 'version-create-modal',
                    'default_version_name' => get_bloginfo('name') . " - v1.0",
                    'current_php_version' => $current_php_version,
                    'current_wordpress_version' => $wp_version,
                ],
                'create_tenant_modal' => [
                    'title' => __('Export to WPCS as Tenant', WPCS_MIGRATION_TEXTDOMAIN),
                    'id' => 'tenant-create-modal',
                    'default_tenant_name' => get_bloginfo('name'),
                ],
            ],
        ]);
    }
}
