<?php
namespace WPCS\Migration\Admin;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) )
    exit;

class Notices
{
    public static function init()
    {
        global $pagenow;

        if ($pagenow !== "tools.php") {
            add_action( 'admin_notices', [__CLASS__, 'show_getting_started_notice'] );
        }
    }

    public static function show_getting_started_notice()
    {
        ?>
        <div class="notice notice-success is-dismissible">
            <h1>WPCS</h1>
            <p><a href="<?php echo home_url('/wp-admin/tools.php?page='.WPCS_MIGRATION_SLUG) ?>">Get started</a></p>
        </div>
        <?php
    }
}
