<?php
namespace WPCS\Migration\Admin;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) )
    exit;

class Twig
{
    private static $twig;

    public static function init()
    {
        $loader = new \Twig\Loader\FilesystemLoader(__DIR__ . "/Templates");
        self::$twig = new \Twig\Environment($loader, [
            'strict_variables' => true,
            'debug' => defined(WP_DEBUG),
            'cache'=> false,
        ]);
    }

    public static function render($template, $data)
    {
        if (!self::$twig) {
            self::init();
        }

        return self::$twig->render($template, $data);
    }
}
