<?php
namespace WPCS\Migration;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) )
    exit;

class Core
{
     /**
     * @return Core
     */
    public static function get_instance() 
    {
        static $instance = false;

        if ( !$instance ) {
            $class    = get_called_class();
            $instance = new $class();
        }

        return $instance;
    }

    protected function __construct() 
    {
        if(!defined( 'CHROME_DEBUG' ))
        {
            define( 'CHROME_DEBUG', false );
        }

        // Note: we need to run this on the action below, so we have our logger available in our classes
        add_action( 'wpcs/migration/core/loaded', [ $this, 'init' ], 5 );
    }

    public function init() 
    {
        API\Module::init();
        Admin\Module::init();
        Updater\Module::init();
    }
}
