<?php
namespace WPCS\Migration\Export;

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) )
    exit;

use Ifsnop\Mysqldump as IMysqldump;
use WPCS\Migration\Helpers;

class Db
{
    public static function createDump($dir)
    {
        global $wpdb;

        try {
            $db_host = DB_HOST;
            $db_name = DB_NAME;

            $rand = rand();
            $path = Helpers::join_paths($dir, "db-{$rand}.sql");

            $dumper = new IMysqldump\Mysqldump("mysql:host={$db_host};dbname={$db_name}", DB_USER, DB_PASSWORD);
            $dumper->start($path);

            $current_prefix = $wpdb->prefix;
            $target_prefix = 'wp_';
            if($current_prefix !== $target_prefix)
            {
                $new_rand = rand();
                $new_path = Helpers::join_paths(Helpers::get_wpcs_dir(), "db-{$new_rand}.sql");
                $fixed_prefix_dump_path = self::replace_table_prefix($path, $new_path, $current_prefix, $target_prefix);
                unlink($path);
                $path = $fixed_prefix_dump_path;
            }

            return $path;
        } catch (\Exception $e) {
            error_log('mysqldump-php error: ' . $e->getMessage());
        }
    }

    public static function replace_table_prefix($db_dump_path, $new_db_dump_path, $current_prefix, $target_prefix)
    {
        $replaceable_strings = self::get_replaceable_strings($current_prefix, $target_prefix);

        $read_handle = fopen($db_dump_path, 'r');
        $write_handle = fopen($new_db_dump_path, 'w');
        if (!$read_handle)
        {
            throw new \Exception('Could not open file for reading: '.$db_dump_path);
        }
        if (!$write_handle)
        {
            throw new \Exception('Could not open file for writing: '.$new_db_dump_path);
        }

        while (($line = fgets($read_handle)) !== false)
        {
            $fixed_line = $line;
            foreach ($replaceable_strings as $old => $new)
            {
                $fixed_line = str_replace($old, $new, $fixed_line);
            }
            fwrite($write_handle, $fixed_line);
        }

        fclose($read_handle);
        fclose($write_handle);

        return $new_db_dump_path;
    }

    public static function get_replaceable_strings($current_prefix, $target_prefix)
    {
        global $wpdb;
        $all_current_tables = flatten($wpdb->get_results('SHOW TABLES', ARRAY_N));

        $replaceable_strings = [
            $current_prefix . "capabilities" => $target_prefix . "capabilities",
            $current_prefix . "user_level" => $target_prefix . "user_level",
            $current_prefix . "autosave_draft_ids" => $target_prefix . "autosave_draft_ids",
            $current_prefix . "user_roles" => $target_prefix . "user_roles",
        ];

        array_map(function($table_name) use(&$replaceable_strings, $current_prefix, $target_prefix) {
            $replaceable_strings[$table_name] = str_replace($current_prefix, $target_prefix, $table_name);
        }, $all_current_tables);

        return $replaceable_strings;
    }
}

function flatten(array $array) {
    $return = [];

    array_walk_recursive($array, function($element) use (&$return) {
        $return[] = $element;
    });

    return $return;
}
