<?php
/*
  Plugin Name: WPCS Migration
  Description: Plugin to migrate single sites to WPCS.
  Version: 1.2.11
  Author: WPCS
  Author URI: https://wpcs.io
  Text Domain: wpcs-migration-text
  Requires PHP: 7.2.5
  Update URI: wpcs.io
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) )
    exit;

define( 'WPCS_MIGRATION_SLUG', 'wpcs-migration' );
define( 'WPCS_MIGRATION_PATH', plugin_dir_path( __FILE__ ) );
define( 'WPCS_MIGRATION_URL', plugin_dir_url( __FILE__ ) );
define( 'WPCS_MIGRATION_BASENAME', plugin_basename( __FILE__ ) );
define( 'WPCS_MIGRATION_VERSION', '1.2.11' );
define( 'WPCS_MIGRATION_TEXTDOMAIN', 'wpcs-migration-text' );
define( 'WPCS_MIGRATION_API_NAMESPACE', 'wpcs/migration' );
define( 'WPCS_MIGRATION_UPDATE_URI', 'wpcs.io' );

if ( !defined( 'WPCS_MIGRATION_LOG' ) ) {
    define( "WPCS_MIGRATION_LOG", WPCS_MIGRATION_PATH . 'debug.log' );
}

require WPCS_MIGRATION_PATH . 'vendor/autoload.php';

/**
 * Get Core
 *
 * @return WPCS\Migration\Core
 */
function wpcs_migration_core() {
    return WPCS\Migration\Core::get_instance();
}

add_action( 'plugins_loaded', function(){
    load_plugin_textdomain( WPCS_MIGRATION_TEXTDOMAIN, false, basename( WPCS_MIGRATION_PATH ) . '/languages/' );

    wpcs_migration_core();
    do_action('wpcs/migration/core/loaded');
});
