<?php

namespace WPFunnelsProWebHooks\Functions;

class Wpfnl_Pro_Webhook_Functions {


    /**
     * Get webhook settings by funnel Id
     * 
     * @param String $funnel_id
     * @return Array $settings
     */
    public static function get_webhook_settings( $funnel_id ){
        $settings = get_post_meta( $funnel_id, '_wpfunnels_webhook_settings', true );
        return $settings;
    }


    /**
     * Get all supported events
	 * 
	 * @return Array $supported_events
     */
    public static function get_all_supported_event(){
        
        $supported_events = array(
           
            'upsell_accepted'     => 'Upsell Accepted',
            'upsell_rejected'     => 'Upsell Rejected',
            'downsell_accepted'   => 'Downsell Accepted',
            'downsell_rejected'   => 'Downsell Rejected',
            'optin_submitted_landing' => 'After Optin Form Submitted',
            'optin_submitted_custom'  => 'After Optin Form Submitted',
        );

        return $supported_events;
    } 


    /**
     * Get all supported request body fields for webhook
     * 
	 * @return Array $supported_fields
     */
    public static function get_all_body_fields(){

        $supported_fields = array(
            
            'product_id'        => 'Product ID',
            'product_name'      => 'Product Name',
            'product_quantity'  => 'Product Quantity',
        
            'order_id'      => 'Order ID',
            'order_total'   => 'Order Total',
            'order_status'  => 'Order Status',
        
            'payment_method'    => 'Payment Method',
            'shipping_method'   => 'Shipping Method',
         
            'customer_name'    => 'Customer Name',
            'customer_email'   => 'Customer Email',
            'customer_phone'   => 'Customer Phone',
            'customer_city'    => 'Customer City',
            'customer_address' => 'Customer Address',

            'first_name' => 'Opt-in first name',
            'last_name'  => 'Opt-in last name',
            'email'      => 'Opt-in email',
            'phone'      => 'Opt-in phone',

        );

        return $supported_fields;
    }





    /**
     * Get all request header name for webhook
     * 
	 * @return Array
     */
    public static function get_all_request_header_name(){

        return array(
	
			array(
				'label' => 'Accept',
				'value' => 'Accept',
			),
			array(
				'label' => 'Accept-Charset',
				'value' => 'Accept-Charset',
			),
			array(
				'label' => 'Accept-Encoding',
				'value' => 'Accept-Encoding',
			),
			array(
				'label' => 'Accept-Language',
				'value' => 'Accept-Language',
			),
			array(
				'label' => 'Accept-Datetime',
				'value' => 'Accept-Datetime',
			),
			array(
				'label' => 'Authorization',
				'value' => 'Authorization',
			),
			array(
				'label' => 'Cache-Control',
				'value' => 'Cache-Control',
			),
			array(
				'label' => 'Connection',
				'value' => 'Connection',
			),
			array(
				'label' => 'Cookie',
				'value' => 'Cookie',
			),
			array(
				'label' => 'Content-Length',
				'value' => 'Content-Length',
			),
			array(
				'label' => 'Content-Type',
				'value' => 'Content-Type',
			),
			array(
				'label' => 'Date',
				'value' => 'Date',
			),
			array(
				'label' => 'Expect',
				'value' => 'Expect',
			),
			array(
				'label' => 'Forwarded',
				'value' => 'Forwarded',
			),
			array(
				'label' => 'From',
				'value' => 'From',
			),
			array(
				'label' => 'Host',
				'value' => 'Host',
			),
			array(
				'label' => 'If-Match',
				'value' => 'If-Match',
			),
			array(
				'label' => 'If-Modified-Since',
				'value' => 'If-Modified-Since',
			),
			array(
				'label' => 'If-None-Match',
				'value' => 'If-None-Match',
			),
			array(
				'label' => 'If-Range',
				'value' => 'If-Range',
			),
			array(
				'label' => 'If-Unmodified-Since',
				'value' => 'If-Unmodified-Since',
			),
			array(
				'label' => 'Max-Forwards',
				'value' => 'Max-Forwards',
			),
			array(
				'label' => 'Origin',
				'value' => 'Origin',
			),
			array(
				'label' => 'Pragma',
				'value' => 'Pragma',
			),
			array(
				'label' => 'Proxy-Authorization',
				'value' => 'Proxy-Authorization',
			),
			array(
				'label' => 'Range',
				'value' => 'Range',
			),
			array(
				'label' => 'Referer',
				'value' => 'Referer',
			),
			array(
				'label' => 'TE',
				'value' => 'TE',
			),
			array(
				'label' => 'User-Agent',
				'value' => 'User-Agent',
			),
			array(
				'label' => 'Upgrade',
				'value' => 'Upgrade',
			),
			array(
				'label' => 'Via',
				'value' => 'Via',
			),
			array(
				'label' => 'Warning',
				'value' => 'Warning',
			),
		);
    }


    /**
     * Get request url
     * 
     * @param Array $setting
     * @return String $url
     */
    public static function get_request_url( $setting ){
        return $setting['request']['url'];
    }


    /**
     * Prepare request url
     * 
     * @param Array $setting
     * @param String $order_id
     * @param String $event_name
	 * 
     * @return String $url
     */
    public static function prepare_request_body( $settings , $order_id, $event_name ){

        $body = array();
        $body['Event name'] =  $event_name;
        $order = wc_get_order($order_id);
        if( $settings['request']['body']['type'] === 'selected' ){
            foreach( $settings['request']['body']['values'] as $key => $value ){
                if( $key == 'order_id' ){
                    $body[$value] = $order_id;
                }elseif( $key === 'total_price' ){
                    $body[$value] = $order->get_total();
                }
            }
        }   
        return $body;
    }


	/**
	 * Prepare request header for webhook
	 * 
	 * @param Array $header
	 */
	public static function prepare_request_header( $headers ){

		$formatted_header = array();
		foreach( $headers as $header ){
			$formatted_header[$header['name']] = $header['value'];
		}

		return $formatted_header;
	}

	/**
	 * Order bump key matching
	 */
	public static function ob_key_matching( $product_id, $item_id ){
		return $product_id == $item_id;
	}






    /**
     * Check webhook status
     * 
     * @param String $status
     * @return Boolean
    */
    public static function check_webhook_status( $status ){
        if( $status === 'on' ){
            return true;
        }
        return false;
    }

    /**
     * Match conditions
     * 
     */
    public static function match_conditions( $value, $rule ){
        return $rule === $value;
    }

	
    /**
     * Get class instance
     */
    public static function get_class_instance( $event, $settings, $record = [], $order_id = '', $offer_product = '' , $offer_status = '', $proudct_id = '', $type = '' , $cookie_data = [], $step_id = '' ){
        
        $class_name = "WPFunnelsProWebHooks\\Events\\".'Wpfnl_Pro_Webhook_'.ucfirst($type).ucfirst($event);
        if ( class_exists(ucfirst($class_name))) {
            if( $event === 'offer' ){
				if( !$type ){
                	return new $class_name( $settings, $order_id, $offer_product, $offer_status);
				}else{
					if( $cookie_data ){
						return new $class_name( $settings , $cookie_data, $offer_status, $proudct_id, $step_id );
					}
				}
            }else if( $event === 'optin' ) {
                return new $class_name( $settings , $record );
            }elseif( $event === 'orderbump' ){
				if( !$type ){
					return new $class_name( $settings , $order_id, $offer_status, $proudct_id );
				}else{
					if( $cookie_data ){
						return new $class_name( $settings , $cookie_data, $offer_status, $proudct_id );
					}
					
				}
                
            }
        }else {
            return false;
        }
    }


    


}