<?php
/**
 * View general settings
 * 
 * @package
 */

	$builders = \WPFunnels\Wpfnl_functions::get_supported_builders();

?>


<div class="wpfnl-box">
    <div class="wpfnl-field-wrapper">
        <label><?php echo __('Funnel Type', 'wpfnl'); ?></label>
        <div class="wpfnl-fields">
            <select name="page-builder" id="wpfunnels-funnel-type">
                <!-- <option value=""><?php echo __('Select Funnel Type', 'wpfnl'); ?></option> -->
                <?php if( $this->is_allow_sales ){ ?>
                    <option value="sales" <?php selected($this->general_settings['funnel_type'], 'sales'); ?> ><?php echo __('Sales', 'wpfnl'); ?></option>
                <?php } ?>
                <option value="lead" <?php selected($this->general_settings['funnel_type'], 'lead'); ?> ><?php echo __('Lead Gen', 'wpfnl'); ?></option>
            </select>
        </div>
    </div>
    <!-- /field-wrapper -->

    <div class="wpfnl-field-wrapper">
        <label><?php echo __('Page Builder', 'wpfnl'); ?></label>
        <div class="wpfnl-fields">
            <select name="page-builder" id="wpfunnels-page-builder">
				<?php
					foreach ( $builders as $key => $value ) { ?>
						<option value="<?php echo $key; ?>" <?php selected($this->general_settings['builder'], $key); ?> ><?php echo $value; ?></option>
					<?php }
				?>
			</select>
        </div>
    </div>


    <div class="wpfnl-field-wrapper sync-template">
        <label class="has-tooltip">
            <?php echo __('Sync Template', 'wpfnl'); ?>

            <span class="wpfnl-tooltip">
                <?php require WPFNL_DIR . '/admin/partials/icons/question-tooltip-icon.php'; ?>
                <p><?php echo __('Click to get the updated funnel templates, made using your preferred page builder, when creating funnels.', 'wpfnl'); ?></p>
            </span>
        </label>
        <div class="wpfnl-fields">
            <button class="btn-default clear-template" id="clear-template">
                <span class="sync-icon"><?php require WPFNL_DIR . '/admin/partials/icons/sync-icon.php'; ?></span>
                <span class="check-icon"><?php require WPFNL_DIR . '/admin/partials/icons/check-icon.php'; ?></span>
                Sync Templates
            </button>
            <span class="wpfnl-alert"></span>
        </div>
    </div>
    <!-- /field-wrapper -->


<!--	<div class="wpfnl-field-wrapper sync-template">-->
<!--		<label class="has-tooltip">-->
<!--			--><?php //echo __( 'WPFunnels Transients', 'wpfnl' ); ?>
<!--			<span class="wpfnl-tooltip">-->
<!--                --><?php //require WPFNL_DIR . '/admin/partials/icons/question-tooltip-icon.php'; ?>
<!--                <p>--><?php //echo __('This tool will clear the WPFunnels transients cache.', 'wpfnl'); ?><!--</p>-->
<!--            </span>-->
<!--		</label>-->
<!--		<div class="wpfnl-fields">-->
<!--			<button class="btn-default clear-template" id="clear-transients">-->
<!--				<span class="sync-icon">--><?php //require WPFNL_DIR . '/admin/partials/icons/sync-icon.php'; ?><!--</span>-->
<!--				<span class="check-icon">--><?php //require WPFNL_DIR . '/admin/partials/icons/check-icon.php'; ?><!--</span>-->
<!--				--><?php //echo __('Delete transients', 'wpfnl'); ?>
<!--			</button>-->
<!--			<span class="wpfnl-alert"></span>-->
<!--		</div>-->
<!--	</div>-->
</div>
<!-- /settings-box -->
