<?php
/**
 * Remote class
 * 
 * @package
 */
namespace WPFunnels\TemplateLibrary;

use WPFunnels\API;
use WPFunnels\Rest\Controllers\TemplateLibraryController;
use WPFunnels\Wpfnl;
use WPFunnels\Wpfnl_functions;
use function cli\err;
use WPFunnelsPro\AbTesting\Wpfnl_Ab_Testing;
class Wpfnl_Source_Remote extends Wpfnl_Source_Base
{

    /**
     * Get souce
     * 
     * @return String
     */
    public function get_source()
    {
        return 'remote';
    }

    /**
     * Get funnels
     * 
     * @return Obj
     */
    public function get_funnels($arg = [])
    {
        return API::get_funnels_data($arg);
    }


    /**
     * Get funnel
     */
    public function get_funnel($template_id)
    {
    }

    /**
     * Get data
     * 
     * @param Array $args
     * 
     * @return String
     */
    public function get_data(array $args)
    {
    }


	/**
	 * Import funnel
	 *
	 * @param array $args
     * 
	 * @return array
	 */
    public function import_funnel($args = [])
    {
        $funnel 	= Wpfnl::$instance->funnel_store;
        $funnel_id 	= $funnel->create();
        $funnel->update_meta($funnel_id, '_is_imported', 'yes');

		if( $funnel_id ){
			$general_settings = get_option( '_wpfunnels_general_settings' );
			if( isset( $general_settings['funnel_type'] ) ){
				if( 'woocommerce' == $general_settings['funnel_type'] ){
					$general_settings['funnel_type'] = 'sales';
					update_option( '_wpfunnels_general_settings', $general_settings );
				}
				if( 'sales' == $general_settings['funnel_type'] ){
					if( Wpfnl_functions::is_lms_addon_active() && isset($args['type']) && 'lms' === $args['type'] ){
						update_post_meta( $funnel_id, '_wpfnl_funnel_type', 'lms' );
					} elseif( Wpfnl_functions::is_wc_active() && isset($args['type']) && 'wc' === $args['type'] ){
						update_post_meta( $funnel_id, '_wpfnl_funnel_type', 'wc' );
					} elseif( isset($args['type']) && 'lead' === $args['type'] ){
						update_post_meta( $funnel_id, '_wpfnl_funnel_type', 'lead' );
					}
				}else{
					if( isset($args['type']) && 'lead' === $args['type'] ){
                        update_post_meta( $funnel_id, '_wpfnl_funnel_type', 'lead' );
                    }
				}
			}
		}


		$remote_id 		= isset($args['remoteID']) ? $args['remoteID'] : 0;
		if ( !$remote_id ) {
			return array(
				'success' => false,
			);
		}
		$response		= TemplateLibraryController::get_funnel( $remote_id );
		$funnel_data 	= $response['funnel_data'];
		update_post_meta( $funnel_id, 'funnel_data', $funnel_data );

        $funnel_title = isset($args['name']) ? $args['name'] : '';
        $params = array(
            'ID' => $funnel_id,
            'post_title' => $funnel_title,
            'post_name' => sanitize_title($funnel_title),
        );
        wp_update_post($params);
        return [
            'success' => true,
            'funnelID' => $funnel_id,
        ];
    }


	/**
	 * Import step
	 *
	 * @param array $args
     * 
	 * @return array
	 */
    public function import_step( $args = [] )
    {
        if (empty($args['funnelID'])) {
            return [
                'success' => true,
                'message' => __('No funnel id found', 'wpfnl'),
            ];
        }
        do_action('wpfunnel_step_import_start');
        $response = TemplateLibraryController::get_step($args['step']['ID']);
        
        $title = $response['title'];
        $post_content = $response['content'];
        $post_metas = $response['post_meta'];
        $builder = Wpfnl_functions::get_builder_type();

        $step = Wpfnl::$instance->step_store;
        $step_id = $step->create_step($args['funnelID'], $title, $args['step']['step_type'], $post_content);
        $step->import_metas($step_id, $post_metas);


        // re-signing the shortcode signature keys if builder type is oxygen
        if( 'oxygen' === Wpfnl_functions::get_builder_type() ) {
        	$ct_shortcodes 	= get_post_meta( $step_id, 'ct_builder_shortcodes', true );
			$ct_shortcodes 	= parse_shortcodes($ct_shortcodes, false, false);
			$shortcodes = parse_components_tree($ct_shortcodes['content']);
			update_post_meta($step_id, 'ct_builder_shortcodes', $shortcodes);
		}

		if ( 'divi-builder' === Wpfnl_functions::get_builder_type() ) {
			if ( isset( $response['data']['divi_content'] ) && ! empty( $response['data']['divi_content'] ) ) {
				update_post_meta( $step_id, 'divi_content', $response['data']['divi_content'] );
				wp_update_post(
					array(
						'ID' 			=> $step_id,
						'post_content' 	=> $response['data']['divi_content']
					)
				);
			}
		}

        if ( 'gutenberg' === Wpfnl_functions::get_builder_type() ) {
			if ( isset( $response['data']['rawData'] ) && ! empty( $response['data']['rawData'] ) ) {
				wp_update_post(
					array(
						'ID' => $step_id,
						'post_content' => $response['data']['rawData']
                	)
				);
			}
        }

        $funnel = Wpfnl::$instance->funnel_store;
        $funnel->set_id($args['funnelID']);
        $funnel->set_steps_order();
        $funnel->save_steps_order( $step_id, $args['step']['step_type'], $title );

		if( isset($args['importType']) && $args['importType'] === 'templates' ) {
			$this->update_step_id_in_funnel_data_and_identifier( $args['step']['ID'], $step_id, $args );
		}
        do_action('wpfunnels/update_ab_testing_start_settings', $step_id);
        do_action('wpfunnels_step_import_complete');
        do_action('wpfunnels_after_step_import', $step_id, $builder);
		update_post_meta($step_id, '_wp_page_template', 'wpfunnels_default');

        return [
            'success' 		=> true,
            'stepID' 		=> $step_id,
			'stepEditLink'	=> get_edit_post_link($step_id),
			'stepViewLink'	=> get_permalink($step_id),
            'abTestingSettingsData'=> $this->get_default_start_setting($step_id),
        ];


    }
   
    /**
     * Import variation step
     * 
     * @param Array $args
     * 
     * @return Array
     */
    public function import_variation_step( $args = [] )
    {
        if (empty($args['funnelID'])) {
            return [
                'success' => true,
                'message' => __('No funnel id found', 'wpfnl'),
            ];
        }
        do_action('wpfunnel_step_import_start');
        $response = TemplateLibraryController::get_step($args['step']['id']);

        $title = isset($args['step_name']) ? $args['step_name'] : $response['title'];
        $post_content = $response['content'];
        $post_metas = $response['post_meta'];

        $builder = Wpfnl_functions::get_builder_type();

        $step = Wpfnl::$instance->step_store;
        $step_id = $step->create_step($args['funnelID'], $title, $args['step']['step_type'], $post_content,false);
        $step->import_metas($step_id, $post_metas);

        if( 'oxygen' === Wpfnl_functions::get_builder_type() ) {
        	$ct_shortcodes 	= get_post_meta( $step_id, 'ct_builder_shortcodes', true );
			$ct_shortcodes 	= parse_shortcodes($ct_shortcodes, false, false);
			$shortcodes = parse_components_tree($ct_shortcodes['content']);
			update_post_meta($step_id, 'ct_builder_shortcodes', $shortcodes);
		}

		if ( 'divi-builder' === Wpfnl_functions::get_builder_type() ) {
			if ( isset( $response['data']['divi_content'] ) && ! empty( $response['data']['divi_content'] ) ) {
				update_post_meta( $step_id, 'divi_content', $response['data']['divi_content'] );
				wp_update_post(
					array(
						'ID' 			=> $step_id,
						'post_content' 	=> $response['data']['divi_content']
					)
				);
			}
		}

        if ( 'gutenberg' === Wpfnl_functions::get_builder_type() ) {
			if ( isset( $response['data']['rawData'] ) && ! empty( $response['data']['rawData'] ) ) {
				wp_update_post(
					array(
						'ID' => $step_id,
						'post_content' => $response['data']['rawData']
                	)
				);
			}
        }

        $funnel = Wpfnl::$instance->funnel_store;
        $funnel->set_id($args['funnelID']);
        $funnel->set_steps_order();
        $funnel->save_steps_order( $step_id, $args['step']['step_type'], $title );


		if( isset($args['importType']) && $args['importType'] === 'templates' ) {
			$this->update_step_id_in_funnel_data_and_identifier( $args['step']['id'], $step_id, $args );
		}

        $funnel_data    = get_post_meta( $args['funnelID'], 'funnel_data', true );
        $steps          = $funnel_data['drawflow']['Home']['data'];
        foreach ( $steps as $key => $step_data ) {
            $node_data = $step_data['data'];
            if ( 'conditional' != $node_data['step_type'] && $step_id == $node_data['step_id'] ) {
                $step_data['class'] = $step_data['class'].'-'.'has-ab-variation';
                $funnel_data['drawflow']['Home']['data'][$key] = $step_data;
            }
        }
        update_post_meta($args['funnelID'], 'funnel_data', $funnel_data);

        /**
         * Update ab testig settings
         *
         * @param Integer $args['step_id'] - this is parent step id
         * @param Integer $step_id - this is parent variant id
         */
        do_action('wpfunnels/update_ab_testing_settings', $args['step_id'], $step_id );
        do_action('wpfunnels_step_import_complete');
        do_action('wpfunnels_after_step_import', $step_id, $builder);
		update_post_meta($step_id, '_wp_page_template', 'wpfunnels_default');
		
        $response = [
            'success' 		=> true,
            'stepID' 		=> $step_id,
			'stepEditLink'	=> get_edit_post_link($step_id),
			'stepViewLink'	=> get_permalink($step_id),
        ];

        return apply_filters('wpfunnels/modify_import_variant_response', $response, $args['step_id'] );

    }


    /**
     * Get default start settings
     */
    private function get_default_start_setting(  $step_id ){
        $step_edit_link =  get_edit_post_link($step_id);
        if( 'elementor' ==  Wpfnl_functions::get_builder_type() ){
            $step_edit_link = str_replace('/&amp;/g','&',$step_edit_link);
            $step_edit_link = str_replace('edit','elementor',$step_edit_link);
        }
        $default_settings = [
            'is_ab_enabled'         => '',
            'start_settings'        => [
                'auto_winner' => [
                    'is_enabled' => '',
                    'conditions' => [
                        'index'  => 'trafiic',
                        'value'  =>   70
                    ]
                ],
                'winner'      => '',
                'is_started'  => '',
                'start_date'  => date( 'Y-m-d H:i:s' ),
                'variations'  => [
                    [
                        'id'      => $step_id,
                        'traffic' => 100,
                        'step_type'=>  get_post_meta($step_id,'_step_type',true),
                        'variation_type'     => 'original',
                        'step_edit_link'   		=> $step_edit_link,
                        'step_view_link'   		=> get_post_permalink($step_id),
                        'step_title'       		=> get_the_title($step_id),
                        'conversion'       		=> 0,
                        'visit'       			=> 0,
                        'shouldShowAnalytics' 	=> false,
                    ],
                ],
            ]

        ];

        return $default_settings;
    }


    /**
     * Update funnel identifier
     * 
     * @param $remote_step
     * @param $new_step
     * @param $args
     * 
     * @return void
     */
    public function update_step_id_in_funnel_data_and_identifier( $remote_step, $new_step, $args )
    {
        $funnel_id 			= $args['funnelID'];
        $funnel_identifier 	= array();
		$funnel_data 		= array();
		$funnel_json 		= get_post_meta( $funnel_id, 'funnel_data', true );
        if ($funnel_json) {
            if(is_array($funnel_json)) {
                $funnel_data = $funnel_json;
            } else {
                $funnel_data = json_decode($funnel_json,1);
            }
            $node_data = $funnel_data['drawflow']['Home']['data'];
            foreach ($node_data as $node_key => $node_value) {
				if ( isset($node_value['data']['step_id']) && $node_value['data']['step_id'] == $remote_step ) {
					$post_edit_link = base64_encode(get_edit_post_link($new_step));
					$post_view_link = base64_encode(get_post_permalink($new_step));
					$funnel_data['drawflow']['Home']['data'][$node_key]['data']['step_id'] = $new_step;
					$funnel_data['drawflow']['Home']['data'][$node_key]['data']['step_edit_link'] = $post_edit_link;
					$funnel_data['drawflow']['Home']['data'][$node_key]['data']['step_view_link'] = $post_view_link;
					$funnel_data['drawflow']['Home']['data'][$node_key]['html'] = $node_value['data']['step_type'] . $new_step;
					$funnel_identifier[$node_value['id']] = $new_step;
				} else {
					if ($node_value['data']['step_type'] != 'conditional') {
						$funnel_identifier[$node_value['id']] = $node_value['data']['step_id'];
					} else {
						$funnel_identifier[$node_value['id']] = $node_value['data']['node_identifier'];
					}
				}
            }
        }

        if ( $funnel_data ) {
            update_post_meta($funnel_id, 'funnel_data', $funnel_data);

            /**
             * Save steps data 
            */
			$steps = $this->get_steps( $funnel_data );
			update_post_meta( $funnel_id, '_steps', $steps );
            Wpfnl_functions::generate_first_step( $funnel_id, $steps );
        }

        if ($funnel_identifier) {
            $funnel_identifier_json = json_encode($funnel_identifier, JSON_UNESCAPED_SLASHES);
            update_post_meta($funnel_id, 'funnel_identifier', $funnel_identifier_json);
        }
    }


	/**
	 * Get steps
	 *
	 * @param $funnel_flow_data
     * 
	 * @return array
	 *
	 * @since 2.0.5
	 */
	private function get_steps( $funnel_flow_data ) {
		$drawflow		= $funnel_flow_data['drawflow'];
		$steps 			= array();
		if( isset( $drawflow['Home']['data'] ) ) {
			$drawflow_data = $drawflow['Home']['data'];
			foreach ( $drawflow_data as $key => $data ) {
				$step_data 	= $data['data'];
				$step_type 	= $step_data['step_type'];
				if('conditional' !== $step_type) {
					$step_id 	= $step_data['step_id'];
					$step_name	= sanitize_text_field(get_the_title($step_data['step_id']));
					$steps[]	= array(
						'id'		=> $step_id,
						'step_type'	=> $step_type,
						'name'		=> $step_name,
					);
				}

			}
		}
		return $steps;
	}
}
