<?php
/**
 * This class is responsible for all discount calculation
 * 
 * @package WPFunnels\Discount
 */
namespace WPFunnels\Discount;

class WpfnlDiscount{


    /**
	 * Calculate price after discount
	 *
	 * @param $discount_type Discount type can be percentage and flat amount.
	 * @param $discount_value Discount amount.
	 * @param $price Product price where you want to add discount
	 * 
     * @since 2.7.6
	 * @return Number
	 */
	public function calculate_discount( $discount_type, $discount_value, $price ) {
		$custom_price = $price;
		if (!empty($discount_type)) {
            $price          = (float)$price;
            $discount_value = (float)$discount_value;
            if( is_numeric($price) && is_numeric($discount_value) ){
                if ('discount-percentage' === $discount_type) {
                    if ( $discount_value > 0 && $discount_value <= 100) {
                        $custom_price = $price - (($price * $discount_value) / 100);
                        $custom_price = number_format((float)$custom_price,2, '.', '');
                    }
                } elseif ('discount-price' === $discount_type) {
                    if ($discount_value > 0 && $price >= $discount_value ) {
                        $custom_price = $price - $discount_value;
                        $custom_price = number_format($custom_price, 2);
                    }
                }
            }
		}
		return $custom_price;
	}


    /**
	 * Get discount amount
	 *
	 * @param $discount_type Discount type can be percentage and flat amount.
	 * @param $discount_value Discount amount.
	 * @param $product_price Product price where you want to add discount
	 * 
     * @since 2.7.6
	 * @return Mix Number or Boolean 
	 */
	public static function get_discount_amount( $discount_type, $discount_value, $price ) {
        $discount = false;
		if (!empty($discount_type) && 'original' !== $discount_type ) {
            $price          = (float)$price;
            $discount_value = (float)$discount_value;
            if( is_numeric($price) && is_numeric($discount_value) ){
                if ('discount-percentage' === $discount_type) {
                    if ( $discount_value > 0 && $discount_value <= 100) {
                        $discount = (($price * $discount_value) / 100);
                    }
                } elseif ('discount-price' === $discount_type) {
                    if ($discount_value > 0 && $price >= $discount_value ) {
                        $discount = $discount_value;
                    }
                }
                if( $discount ){
                    $discount = number_format($discount, 2);
                }
            }
		}
		return $discount;
	}


    /**
     * Get discount settings by step id from postmeta
     * 
     * @param $step_id Step ID.
     * 
     * @since 2.7.6
     * @return Mix Array or boolean
     */
    public function get_discount_settings( $step_id ){
        $discount = false;
        if( $step_id ){
            $step_type =  get_post_meta( $step_id, '_step_type', true );
            if( 'checkout' ===  $step_type ){
                $discount = get_post_meta( $step_id, '_wpfnl_checkout_discount_main_product', true );
            }elseif( 'upsell' ===  $step_type || 'downsell' === $step_type ){
                $discount = get_post_meta( $step_id, '_wpfnl_'.$step_type.'_discount', true );
            }
        }
        return $discount;
    }
}