<?php
/**
 * SlimSeo Compatibility
 * 
 * @package
 */
namespace WPFunnels\Compatibility\SlimSeo;

use WPFunnels\Wpfnl_functions;
use WPFunnels\Traits\SingletonTrait;

/**
 * Slim seo Compatibility
 * 
 * @package WPFunnels\Compatibility\SlimSeo
 */
class Wpfnl_Slim_Seo_Compatibility{
	use SingletonTrait;

	/**
	 * Filters/Hook from Slim Seo
	 * to initiate the necessary updates.
	 *
	 * @since 2.5.7
	 */
	public function init() {
		add_filter( 'slim_seo_meta_description', [ $this, 'wpfnl_no_description' ] );
	}


    /**
     * Compatibility with Slim seo by retuning false of this filter hook
     * 
     * @return Bool
     * @since  2.5.7
     */
    public function wpfnl_no_description(){
        return false;
    }

	
}
